/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.web.autoconfigure.mvc;

import com.cssw.bootx.web.autoconfigure.mvc.converter.BaseEnumConverterFactory;
import com.cssw.bootx.web.autoconfigure.mvc.converter.time.DateConverter;
import com.cssw.bootx.web.autoconfigure.mvc.converter.time.LocalDateConverter;
import com.cssw.bootx.web.autoconfigure.mvc.converter.time.LocalDateTimeConverter;
import com.cssw.bootx.web.autoconfigure.mvc.converter.time.LocalTimeConverter;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableWebMvc
@AutoConfiguration
public class WebMvcAutoConfiguration
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebMvcAutoConfiguration.class);
    private final MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter;

    public WebMvcAutoConfiguration(MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter) {
        this.mappingJackson2HttpMessageConverter = mappingJackson2HttpMessageConverter;
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.removeIf(MappingJackson2HttpMessageConverter.class::isInstance);
        if (Objects.isNull(this.mappingJackson2HttpMessageConverter)) {
            converters.add(0, (HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        } else {
            converters.add(0, (HttpMessageConverter<?>)this.mappingJackson2HttpMessageConverter);
        }
        converters.add(0, (HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverterFactory((ConverterFactory)new BaseEnumConverterFactory());
        registry.addConverter((Converter)new DateConverter());
        registry.addConverter((Converter)new LocalDateTimeConverter());
        registry.addConverter((Converter)new LocalDateConverter());
        registry.addConverter((Converter)new LocalTimeConverter());
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Web MVC' completed initialization.");
    }
}

