/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.web.autoconfigure.response;

import com.cssw.bootx.core.yaml.YamlPropertySourceFactory;
import com.cssw.bootx.web.autoconfigure.response.ApiDocGlobalResponseHandler;
import com.cssw.bootx.web.autoconfigure.response.DefaultBeforeControllerAdviceProcessImpl;
import com.cssw.bootx.web.autoconfigure.response.GlobalResponseProperties;
import com.feiniaojin.gracefulresponse.ExceptionAliasRegister;
import com.feiniaojin.gracefulresponse.advice.AdviceSupport;
import com.feiniaojin.gracefulresponse.advice.DataExceptionAdvice;
import com.feiniaojin.gracefulresponse.advice.DefaultGlobalExceptionAdvice;
import com.feiniaojin.gracefulresponse.advice.DefaultRejectStrategyImpl;
import com.feiniaojin.gracefulresponse.advice.DefaultValidationExceptionAdvice;
import com.feiniaojin.gracefulresponse.advice.FrameworkExceptionAdvice;
import com.feiniaojin.gracefulresponse.advice.GrI18nResponseBodyAdvice;
import com.feiniaojin.gracefulresponse.advice.GrNotVoidResponseBodyAdvice;
import com.feiniaojin.gracefulresponse.advice.GrVoidResponseBodyAdvice;
import com.feiniaojin.gracefulresponse.advice.ReleaseExceptionHandlerExceptionResolver;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.BeforeControllerAdviceProcess;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.ControllerAdviceHttpProcessor;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.ControllerAdviceProcessor;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.RejectStrategy;
import com.feiniaojin.gracefulresponse.api.ResponseFactory;
import com.feiniaojin.gracefulresponse.api.ResponseStatusFactory;
import com.feiniaojin.gracefulresponse.defaults.DefaultResponseFactory;
import com.feiniaojin.gracefulresponse.defaults.DefaultResponseStatusFactoryImpl;
import jakarta.annotation.PostConstruct;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.parsers.ReturnTypeParser;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={GlobalResponseProperties.class})
@PropertySource(value={"classpath:default-response.yml"}, factory=YamlPropertySourceFactory.class)
public class GlobalResponseAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalResponseAutoConfiguration.class);
    private final GlobalResponseProperties globalResponseProperties;

    @Bean
    @ConditionalOnMissingBean
    public GrNotVoidResponseBodyAdvice grNotVoidResponseBodyAdvice() {
        return new GrNotVoidResponseBodyAdvice();
    }

    @Bean
    @ConditionalOnMissingBean
    public GrVoidResponseBodyAdvice grVoidResponseBodyAdvice() {
        return new GrVoidResponseBodyAdvice();
    }

    @Bean
    @ConditionalOnMissingBean
    public BeforeControllerAdviceProcess beforeControllerAdviceProcess() {
        return new DefaultBeforeControllerAdviceProcessImpl(this.globalResponseProperties);
    }

    @Bean
    public FrameworkExceptionAdvice frameworkExceptionAdvice(BeforeControllerAdviceProcess beforeControllerAdviceProcess, @Lazy RejectStrategy rejectStrategy) {
        FrameworkExceptionAdvice frameworkExceptionAdvice = new FrameworkExceptionAdvice();
        frameworkExceptionAdvice.setRejectStrategy(rejectStrategy);
        frameworkExceptionAdvice.setControllerAdviceProcessor((ControllerAdviceProcessor)frameworkExceptionAdvice);
        frameworkExceptionAdvice.setBeforeControllerAdviceProcess(beforeControllerAdviceProcess);
        frameworkExceptionAdvice.setControllerAdviceHttpProcessor((ControllerAdviceHttpProcessor)frameworkExceptionAdvice);
        return frameworkExceptionAdvice;
    }

    @Bean
    public DataExceptionAdvice dataExceptionAdvice(BeforeControllerAdviceProcess beforeControllerAdviceProcess, @Lazy RejectStrategy rejectStrategy) {
        DataExceptionAdvice dataExceptionAdvice = new DataExceptionAdvice();
        dataExceptionAdvice.setRejectStrategy(rejectStrategy);
        dataExceptionAdvice.setControllerAdviceProcessor((ControllerAdviceProcessor)dataExceptionAdvice);
        dataExceptionAdvice.setBeforeControllerAdviceProcess(beforeControllerAdviceProcess);
        dataExceptionAdvice.setControllerAdviceHttpProcessor((ControllerAdviceHttpProcessor)dataExceptionAdvice);
        return dataExceptionAdvice;
    }

    @Bean
    public DefaultGlobalExceptionAdvice defaultGlobalExceptionAdvice(BeforeControllerAdviceProcess beforeControllerAdviceProcess, @Lazy RejectStrategy rejectStrategy) {
        DefaultGlobalExceptionAdvice advice = new DefaultGlobalExceptionAdvice();
        advice.setRejectStrategy(rejectStrategy);
        CopyOnWriteArrayList<DefaultGlobalExceptionAdvice> copyOnWriteArrayList = new CopyOnWriteArrayList<DefaultGlobalExceptionAdvice>();
        copyOnWriteArrayList.add(advice);
        advice.setPredicates(copyOnWriteArrayList);
        advice.setControllerAdviceProcessor((ControllerAdviceProcessor)advice);
        advice.setBeforeControllerAdviceProcess(beforeControllerAdviceProcess);
        advice.setControllerAdviceHttpProcessor((ControllerAdviceHttpProcessor)advice);
        return advice;
    }

    @Bean
    public DefaultValidationExceptionAdvice defaultValidationExceptionAdvice(BeforeControllerAdviceProcess beforeControllerAdviceProcess, @Lazy RejectStrategy rejectStrategy) {
        DefaultValidationExceptionAdvice advice = new DefaultValidationExceptionAdvice();
        advice.setRejectStrategy(rejectStrategy);
        advice.setControllerAdviceProcessor((ControllerAdviceProcessor)advice);
        advice.setBeforeControllerAdviceProcess(beforeControllerAdviceProcess);
        advice.setControllerAdviceHttpProcessor((ControllerAdviceHttpProcessor)advice);
        return advice;
    }

    @Bean
    public RejectStrategy rejectStrategy() {
        return new DefaultRejectStrategyImpl();
    }

    @Bean
    public ExceptionHandlerExceptionResolver releaseExceptionHandlerExceptionResolver() {
        return new ReleaseExceptionHandlerExceptionResolver();
    }

    @Bean
    @ConditionalOnProperty(prefix="bootx-starter.web.response", name={"i18n"}, havingValue="true")
    public GrI18nResponseBodyAdvice grI18nResponseBodyAdvice() {
        return new GrI18nResponseBodyAdvice();
    }

    @Bean
    @ConditionalOnProperty(prefix="bootx-starter.web.response", name={"i18n"}, havingValue="true")
    public MessageSource messageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"i18n", "i18n/messages"});
        messageSource.setDefaultEncoding("UTF-8");
        messageSource.setDefaultLocale(Locale.CHINA);
        return messageSource;
    }

    @Bean
    @ConditionalOnMissingBean
    public ResponseFactory responseBeanFactory() {
        return new DefaultResponseFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public ResponseStatusFactory responseStatusFactory() {
        return new DefaultResponseStatusFactoryImpl();
    }

    @Bean
    public ExceptionAliasRegister exceptionAliasRegister() {
        return new ExceptionAliasRegister();
    }

    @Bean
    public AdviceSupport adviceSupport() {
        return new AdviceSupport();
    }

    @Bean
    @ConditionalOnClass(value={ReturnTypeParser.class})
    @ConditionalOnMissingBean
    public ApiDocGlobalResponseHandler apiDocGlobalResponseHandler() {
        return new ApiDocGlobalResponseHandler(this.globalResponseProperties);
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Web-Global Response' completed initialization.");
    }

    @Generated
    public GlobalResponseAutoConfiguration(GlobalResponseProperties globalResponseProperties) {
        this.globalResponseProperties = globalResponseProperties;
    }
}

