/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.web.autoconfigure.server;

import com.cssw.bootx.core.util.CollUtils;
import com.cssw.bootx.core.yaml.YamlPropertySourceFactory;
import com.cssw.bootx.web.autoconfigure.server.ServerExtensionProperties;
import io.undertow.Undertow;
import io.undertow.server.handlers.DisallowedMethodsHandler;
import io.undertow.util.HttpString;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@AutoConfiguration
@ConditionalOnWebApplication
@ConditionalOnClass(value={Undertow.class})
@EnableConfigurationProperties(value={ServerExtensionProperties.class})
@PropertySource(value={"classpath:default-server.yml"}, factory=YamlPropertySourceFactory.class)
@ConditionalOnProperty(prefix="server.extension", name={"enabled"}, havingValue="true")
public class UndertowAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UndertowAutoConfiguration.class);

    @Bean
    public WebServerFactoryCustomizer<UndertowServletWebServerFactory> customize(ServerExtensionProperties properties) {
        return factory -> {
            factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> deploymentInfo.addInitialHandlerChainWrapper(handler -> new DisallowedMethodsHandler(handler, CollUtils.mapToSet(properties.getDisallowedMethods(), HttpString::tryFromString)))});
            log.debug("[Bootx Starter] - Disallowed HTTP methods on Server Undertow: {}.", properties.getDisallowedMethods());
            log.debug("[Bootx Starter] - Auto Configuration 'Web-Server Undertow' completed initialization.");
        };
    }
}

