/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.accessor;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import me.ahoo.cosid.IntegerIdGenerator;
import me.ahoo.cosid.accessor.AbstractIdMetadata;
import me.ahoo.cosid.accessor.CosIdAccessor;
import me.ahoo.cosid.accessor.CosIdGetter;
import me.ahoo.cosid.accessor.CosIdSetter;
import me.ahoo.cosid.accessor.EnsureId;
import me.ahoo.cosid.accessor.IdDefinition;

public class DefaultCosIdAccessor
extends AbstractIdMetadata
implements CosIdAccessor {
    private final CosIdGetter getter;
    private final CosIdSetter setter;
    private final EnsureId ensureId;

    public DefaultCosIdAccessor(IdDefinition idDefinition, CosIdGetter getter, CosIdSetter setter) {
        super(idDefinition);
        this.getter = getter;
        this.setter = setter;
        this.ensureId = this.getEnsureId();
    }

    private EnsureId getEnsureId() {
        Class<?> idFieldType = this.getIdType();
        if (Long.class.equals(idFieldType) || Long.TYPE.equals(idFieldType)) {
            return new EnsureLongId();
        }
        if (Integer.class.equals(idFieldType) || Integer.TYPE.equals(idFieldType)) {
            return new EnsureIntegerId();
        }
        return new EnsureStringId();
    }

    @Override
    public Object getId(Object target) {
        return this.getter.getId(target);
    }

    @Override
    public void setId(Object target, Object id) {
        this.setter.setId(target, id);
    }

    public CosIdGetter getGetter() {
        return this.getter;
    }

    public CosIdSetter getSetter() {
        return this.setter;
    }

    @Override
    public boolean ensureId(Object target) {
        Preconditions.checkArgument((boolean)this.getIdDeclaringClass().isInstance(target), (String)"Target:[%s] is not instance of IdDeclaringClass:[%s]", (Object)target, this.getIdDeclaringClass());
        return this.ensureId.ensureId(target);
    }

    public class EnsureLongId
    implements EnsureId {
        private static final long MIN_ID = 0L;

        @Override
        public boolean ensureId(Object target) {
            Object previousId = DefaultCosIdAccessor.this.getId(target);
            if (null != previousId && (Long)previousId > 0L) {
                return false;
            }
            DefaultCosIdAccessor.this.setId(target, DefaultCosIdAccessor.this.getIdGenerator().generate());
            return true;
        }
    }

    public class EnsureIntegerId
    implements EnsureId {
        private static final int MIN_ID = 0;
        private final IntegerIdGenerator integerIdGenerator;

        public EnsureIntegerId() {
            this.integerIdGenerator = new IntegerIdGenerator(DefaultCosIdAccessor.this.getIdGenerator());
        }

        @Override
        public boolean ensureId(Object target) {
            Object previousId = DefaultCosIdAccessor.this.getId(target);
            if (null != previousId && (Integer)previousId > 0) {
                return false;
            }
            DefaultCosIdAccessor.this.setId(target, this.integerIdGenerator.generate());
            return true;
        }
    }

    public class EnsureStringId
    implements EnsureId {
        @Override
        public boolean ensureId(Object target) {
            Object previousId = DefaultCosIdAccessor.this.getId(target);
            if (null != previousId && !Strings.isNullOrEmpty((String)((String)previousId))) {
                return false;
            }
            DefaultCosIdAccessor.this.setId(target, DefaultCosIdAccessor.this.getIdGenerator().generateAsString());
            return true;
        }
    }
}

