/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.converter;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import me.ahoo.cosid.Decorator;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.stat.Stat;
import me.ahoo.cosid.stat.converter.PrefixConverterStat;

public class PrefixIdConverter
implements IdConverter,
Decorator<IdConverter> {
    private final String prefix;
    private final IdConverter actual;

    public PrefixIdConverter(String prefix, IdConverter actual) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix can not be null!");
        this.prefix = prefix;
        this.actual = actual;
    }

    @Override
    @Nonnull
    public IdConverter getActual() {
        return this.actual;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    @Nonnull
    public String asString(long id) {
        String idStr = this.actual.asString(id);
        if (this.prefix.isEmpty()) {
            return idStr;
        }
        return this.prefix + idStr;
    }

    @Override
    public long asLong(@Nonnull String idString) {
        String idStr = idString.substring(this.prefix.length());
        return this.actual.asLong(idStr);
    }

    @Override
    public Stat stat() {
        return new PrefixConverterStat(this.getClass().getSimpleName(), this.prefix, this.actual.stat());
    }
}

