/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.converter;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import me.ahoo.cosid.Decorator;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.stat.Stat;
import me.ahoo.cosid.stat.converter.SuffixConverterStat;

public class SuffixIdConverter
implements IdConverter,
Decorator<IdConverter> {
    private final String suffix;
    private final IdConverter actual;

    public SuffixIdConverter(String suffix, IdConverter actual) {
        Preconditions.checkNotNull((Object)suffix, (Object)"suffix can not be null!");
        this.suffix = suffix;
        this.actual = actual;
    }

    @Override
    @Nonnull
    public IdConverter getActual() {
        return this.actual;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    @Nonnull
    public String asString(long id) {
        String idStr = this.actual.asString(id);
        if (this.suffix.isEmpty()) {
            return idStr;
        }
        return idStr + this.suffix;
    }

    @Override
    public long asLong(@Nonnull String idString) {
        String idStr = idString.substring(0, idString.length() - this.suffix.length());
        return this.actual.asLong(idStr);
    }

    @Override
    public Stat stat() {
        return new SuffixConverterStat(this.getClass().getSimpleName(), this.suffix, this.actual.stat());
    }
}

