/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.cosid;

import jakarta.annotation.Nonnull;
import lombok.Generated;
import me.ahoo.cosid.Decorator;
import me.ahoo.cosid.cosid.CosIdGenerator;
import me.ahoo.cosid.cosid.CosIdIdStateParser;
import me.ahoo.cosid.cosid.CosIdState;
import me.ahoo.cosid.machine.ClockBackwardsSynchronizer;
import me.ahoo.cosid.snowflake.exception.ClockBackwardsException;
import me.ahoo.cosid.stat.Stat;
import me.ahoo.cosid.stat.generator.IdGeneratorStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockSyncCosIdGenerator
implements CosIdGenerator,
Decorator<CosIdGenerator> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClockSyncCosIdGenerator.class);
    private final CosIdGenerator actual;
    private final ClockBackwardsSynchronizer clockBackwardsSynchronizer;

    public ClockSyncCosIdGenerator(CosIdGenerator actual) {
        this(actual, ClockBackwardsSynchronizer.DEFAULT);
    }

    public ClockSyncCosIdGenerator(CosIdGenerator actual, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        this.actual = actual;
        this.clockBackwardsSynchronizer = clockBackwardsSynchronizer;
    }

    @Override
    @Nonnull
    public CosIdGenerator getActual() {
        return this.actual;
    }

    @Override
    public int getMachineId() {
        return this.actual.getMachineId();
    }

    @Override
    public long getLastTimestamp() {
        return this.actual.getLastTimestamp();
    }

    @Override
    @Nonnull
    public CosIdIdStateParser getStateParser() {
        return this.actual.getStateParser();
    }

    @Override
    @Nonnull
    public CosIdState generateAsState() {
        try {
            return this.actual.generateAsState();
        }
        catch (ClockBackwardsException exception) {
            if (log.isWarnEnabled()) {
                log.warn(exception.getMessage(), (Throwable)exception);
            }
            this.clockBackwardsSynchronizer.syncUninterruptibly(this.actual.getLastTimestamp());
            return this.actual.generateAsState();
        }
    }

    @Override
    public IdGeneratorStat stat() {
        return IdGeneratorStat.simple(this.getClass().getSimpleName(), this.actual.stat(), Stat.simple(this.getStateParser().getClass().getSimpleName()));
    }
}

