/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.segment;

import com.google.errorprone.annotations.ThreadSafe;
import me.ahoo.cosid.segment.NextIdSegmentExpiredException;
import me.ahoo.cosid.segment.grouped.Grouped;
import me.ahoo.cosid.util.Clock;

@ThreadSafe
public interface IdSegment
extends Comparable<IdSegment>,
Grouped {
    public static final long SEQUENCE_OVERFLOW = -1L;
    public static final long TIME_TO_LIVE_FOREVER = Long.MAX_VALUE;

    public long getFetchTime();

    public long getMaxId();

    public long getOffset();

    public long getSequence();

    public long getStep();

    default public long getTtl() {
        return Long.MAX_VALUE;
    }

    default public boolean isExpired() {
        if (Long.MAX_VALUE == this.getTtl()) {
            return false;
        }
        return Clock.SYSTEM.secondTime() - this.getFetchTime() > this.getTtl();
    }

    default public boolean isOverflow() {
        return this.getSequence() >= this.getMaxId();
    }

    default public boolean isOverflow(long nextSeq) {
        return nextSeq == -1L || nextSeq > this.getMaxId();
    }

    default public boolean isAvailable() {
        return !this.isExpired() && !this.isOverflow();
    }

    public long incrementAndGet();

    @Override
    default public int compareTo(IdSegment other) {
        if (this.getOffset() == other.getOffset()) {
            return 0;
        }
        return this.getOffset() > other.getOffset() ? 1 : -1;
    }

    default public void ensureNextIdSegment(IdSegment nextIdSegment) throws NextIdSegmentExpiredException {
        if (this.compareTo(nextIdSegment) >= 0) {
            throw new NextIdSegmentExpiredException(this, nextIdSegment);
        }
    }
}

