/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.segment.grouped;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import me.ahoo.cosid.util.Clock;

public final class GroupedKey {
    public static final GroupedKey NEVER = new GroupedKey("", Long.MAX_VALUE);
    private final String key;
    private final long ttlAt;

    public GroupedKey(String key, long ttlAt) {
        this.key = key;
        this.ttlAt = ttlAt;
    }

    public String getKey() {
        return this.key;
    }

    public long getTtlAt() {
        return this.ttlAt;
    }

    public long ttl() {
        return this.ttlAt - Clock.CACHE.secondTime();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupedKey that = (GroupedKey)o;
        return this.ttlAt == that.ttlAt && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.ttlAt);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("ttlAt", this.ttlAt).toString();
    }

    public static GroupedKey forever(String key) {
        return new GroupedKey(key, Long.MAX_VALUE);
    }
}

