/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.segment.grouped.date;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import me.ahoo.cosid.segment.grouped.GroupBySupplier;
import me.ahoo.cosid.segment.grouped.GroupedKey;

public abstract class AbstractDateGroupBySupplier<D extends TemporalAccessor>
implements GroupBySupplier {
    protected final DateTimeFormatter formatter;

    public AbstractDateGroupBySupplier(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    abstract D now();

    abstract LocalDateTime lastTimestamp(D var1);

    @Override
    public GroupedKey get() {
        D nowDate = this.now();
        String key = this.formatter.format((TemporalAccessor)nowDate);
        LocalDateTime lastTs = this.lastTimestamp(nowDate);
        ZoneId currentZone = ZoneId.systemDefault();
        long ttlAt = lastTs.atZone(currentZone).toInstant().toEpochMilli() / 1000L;
        return new GroupedKey(key, ttlAt);
    }
}

