/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.sharding;

import com.google.common.base.Strings;
import java.time.LocalDateTime;
import lombok.Generated;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.sharding.LocalDateTimeConvertor;
import me.ahoo.cosid.snowflake.SnowflakeIdStateParser;

public class SnowflakeLocalDateTimeConvertor
implements LocalDateTimeConvertor {
    private final SnowflakeIdStateParser snowflakeIdStateParser;

    @Override
    public LocalDateTime toLocalDateTime(Comparable<?> value) {
        return this.snowflakeIdStateParser.parseTimestamp(this.convertToSnowflakeId(value));
    }

    private Long convertToSnowflakeId(Comparable<?> value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Radix62IdConverter.PAD_START.asLong((String)((Object)value));
        }
        throw new IllegalArgumentException(Strings.lenientFormat((String)"Unsupported sharding value type `%s`.", (Object[])new Object[]{value}));
    }

    @Generated
    public SnowflakeLocalDateTimeConvertor(SnowflakeIdStateParser snowflakeIdStateParser) {
        this.snowflakeIdStateParser = snowflakeIdStateParser;
    }
}

