/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.sharding;

import com.google.common.base.Strings;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import lombok.Generated;
import me.ahoo.cosid.sharding.LocalDateTimeConvertor;
import me.ahoo.cosid.util.LocalDateTimeConvert;

public class StandardLocalDateTimeConvertor
implements LocalDateTimeConvertor {
    private final ZoneId zoneId;
    private final boolean isSecondTs;
    private final DateTimeFormatter dateTimeFormatter;

    @Override
    public LocalDateTime toLocalDateTime(Comparable<?> value) {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDateTime();
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toLocalDateTime();
        }
        if (value instanceof Instant) {
            return LocalDateTimeConvert.fromInstant((Instant)value, this.zoneId);
        }
        if (value instanceof LocalDate) {
            return LocalDateTime.of((LocalDate)value, LocalTime.MIN);
        }
        if (value instanceof Date) {
            return LocalDateTimeConvert.fromDate((Date)value, this.zoneId);
        }
        if (value instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)value;
            return LocalDateTime.of(yearMonth.getYear(), yearMonth.getMonthValue(), 1, 0, 0);
        }
        if (value instanceof Year) {
            return LocalDateTime.of(((Year)value).getValue(), 1, 1, 0, 0);
        }
        if (value instanceof Long) {
            return this.isSecondTs ? LocalDateTimeConvert.fromTimestampSecond((Long)value, this.zoneId) : LocalDateTimeConvert.fromTimestamp((Long)value, this.zoneId);
        }
        if (value instanceof String) {
            return LocalDateTimeConvert.fromString((String)((Object)value), this.dateTimeFormatter);
        }
        throw new IllegalArgumentException(Strings.lenientFormat((String)"Unsupported sharding value type `%s`.", (Object[])new Object[]{value}));
    }

    @Generated
    public StandardLocalDateTimeConvertor(ZoneId zoneId, boolean isSecondTs, DateTimeFormatter dateTimeFormatter) {
        this.zoneId = zoneId;
        this.isSecondTs = isSecondTs;
        this.dateTimeFormatter = dateTimeFormatter;
    }
}

