/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake;

import jakarta.annotation.Nonnull;
import lombok.Generated;
import me.ahoo.cosid.IdGeneratorDecorator;
import me.ahoo.cosid.machine.ClockBackwardsSynchronizer;
import me.ahoo.cosid.snowflake.SnowflakeId;
import me.ahoo.cosid.snowflake.exception.ClockBackwardsException;
import me.ahoo.cosid.stat.generator.IdGeneratorStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockSyncSnowflakeId
implements IdGeneratorDecorator,
SnowflakeId {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClockSyncSnowflakeId.class);
    private final SnowflakeId actual;
    private final ClockBackwardsSynchronizer clockBackwardsSynchronizer;

    public ClockSyncSnowflakeId(SnowflakeId actual) {
        this(actual, ClockBackwardsSynchronizer.DEFAULT);
    }

    public ClockSyncSnowflakeId(SnowflakeId actual, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        this.actual = actual;
        this.clockBackwardsSynchronizer = clockBackwardsSynchronizer;
    }

    @Override
    @Nonnull
    public SnowflakeId getActual() {
        return this.actual;
    }

    @Override
    public long generate() {
        try {
            return this.actual.generate();
        }
        catch (ClockBackwardsException exception) {
            if (log.isWarnEnabled()) {
                log.warn(exception.getMessage(), (Throwable)exception);
            }
            this.clockBackwardsSynchronizer.syncUninterruptibly(this.actual.getLastTimestamp());
            return this.actual.generate();
        }
    }

    @Override
    public IdGeneratorStat stat() {
        return IdGeneratorDecorator.super.stat();
    }

    @Override
    public long getEpoch() {
        return this.actual.getEpoch();
    }

    @Override
    public int getTimestampBit() {
        return this.actual.getTimestampBit();
    }

    @Override
    public int getMachineBit() {
        return this.actual.getMachineBit();
    }

    @Override
    public int getSequenceBit() {
        return this.actual.getSequenceBit();
    }

    @Override
    public boolean isSafeJavascript() {
        return this.actual.isSafeJavascript();
    }

    @Override
    public long getMaxTimestamp() {
        return this.actual.getMaxTimestamp();
    }

    @Override
    public int getMaxMachineId() {
        return this.actual.getMaxMachineId();
    }

    @Override
    public long getMaxSequence() {
        return this.actual.getMaxSequence();
    }

    @Override
    public long getLastTimestamp() {
        return this.actual.getLastTimestamp();
    }

    @Override
    public int getMachineId() {
        return this.actual.getMachineId();
    }
}

