/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake;

import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.stat.generator.IdGeneratorStat;
import me.ahoo.cosid.stat.generator.SnowflakeIdStat;

public interface SnowflakeId
extends IdGenerator {
    public static final int TOTAL_BIT = 63;

    public long getEpoch();

    public int getTimestampBit();

    public int getMachineBit();

    public int getSequenceBit();

    default public boolean isSafeJavascript() {
        return this.getTimestampBit() + this.getMachineBit() + this.getSequenceBit() <= 53;
    }

    public long getMaxTimestamp();

    public int getMaxMachineId();

    public long getMaxSequence();

    public long getLastTimestamp();

    public int getMachineId();

    public static long defaultSequenceResetThreshold(int sequenceBit) {
        return -1L << sequenceBit - 1 ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    default public IdGeneratorStat stat() {
        return new SnowflakeIdStat(this.getClass().getSimpleName(), this.getEpoch(), this.getTimestampBit(), this.getMachineBit(), this.getSequenceBit(), this.isSafeJavascript(), this.getMachineId(), this.getLastTimestamp(), this.idConverter().stat());
    }
}

