/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.util;

import com.google.errorprone.annotations.ThreadSafe;
import java.time.Duration;
import java.util.concurrent.locks.LockSupport;

@ThreadSafe
@FunctionalInterface
public interface Clock {
    public static final Clock SYSTEM = new SystemClock();
    public static final Clock CACHE = new CacheClock(SYSTEM);

    public long secondTime();

    public static long getSystemSecondTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static class SystemClock
    implements Clock {
        @Override
        public long secondTime() {
            return Clock.getSystemSecondTime();
        }
    }

    public static class CacheClock
    implements Clock,
    Runnable {
        public static final long ONE_SECOND_PERIOD = Duration.ofSeconds(1L).toNanos();
        private final Clock clock;
        private final Thread thread;
        private volatile long lastTime;

        public CacheClock(Clock clock) {
            this.clock = clock;
            this.lastTime = clock.secondTime();
            this.thread = new Thread(this);
            this.thread.setName("CosId-CacheClock");
            this.thread.setDaemon(true);
            this.thread.start();
        }

        @Override
        public long secondTime() {
            return this.lastTime;
        }

        @Override
        public void run() {
            while (!this.thread.isInterrupted()) {
                long currentTime = this.clock.secondTime();
                if (currentTime > this.lastTime) {
                    this.lastTime = currentTime;
                }
                LockSupport.parkNanos(this, ONE_SECOND_PERIOD);
            }
        }
    }
}

