/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.enums.scope.AuthJdScope;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.AuthScopeUtils;
import me.zhyd.oauth.utils.GlobalAuthUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthJdRequest
extends AuthDefaultRequest {
    public AuthJdRequest(AuthConfig config) {
        super(config, AuthDefaultSource.JD);
    }

    public AuthJdRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.JD, authStateCache);
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        HashMap<String, String> params = new HashMap<String, String>(7);
        params.put("app_key", this.config.getClientId());
        params.put("app_secret", this.config.getClientSecret());
        params.put("grant_type", "authorization_code");
        params.put("code", authCallback.getCode());
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.accessToken(), params, false).getBody();
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AuthToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).refreshToken(object.getString("refresh_token")).scope(object.getString("scope")).openId(object.getString("open_id")).build();
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        UrlBuilder urlBuilder = UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("app_key", this.config.getClientId()).queryParam("method", "jingdong.user.getUserInfoByOpenId").queryParam("360buy_param_json", "{\"openId\":\"" + authToken.getOpenId() + "\"}").queryParam("timestamp", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).queryParam("v", "2.0");
        urlBuilder.queryParam("sign", GlobalAuthUtils.generateJdSignature(this.config.getClientSecret(), urlBuilder.getReadOnlyParams()));
        String response = new HttpUtils(this.config.getHttpConfig()).post(urlBuilder.build(true)).getBody();
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        JSONObject data = this.getUserDataJsonObject(object);
        return AuthUser.builder().rawUserInfo(data).uuid(authToken.getOpenId()).username(data.getString("nickName")).nickname(data.getString("nickName")).avatar(data.getString("imageUrl")).gender(AuthUserGender.getRealGender(data.getString("gendar"))).token(authToken).source(this.source.toString()).build();
    }

    private JSONObject getUserDataJsonObject(JSONObject object) {
        return object.getJSONObject("jingdong_user_getUserInfoByOpenId_response").getJSONObject("getuserinfobyappidandopenid_result").getJSONObject("data");
    }

    @Override
    public AuthResponse<AuthToken> refresh(AuthToken oldToken) {
        HashMap<String, String> params = new HashMap<String, String>(7);
        params.put("app_key", this.config.getClientId());
        params.put("app_secret", this.config.getClientSecret());
        params.put("grant_type", "refresh_token");
        params.put("refresh_token", oldToken.getRefreshToken());
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.refresh(), params, false).getBody();
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(AuthToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).refreshToken(object.getString("refresh_token")).scope(object.getString("scope")).openId(object.getString("open_id")).build()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error_response")) {
            throw new AuthException(object.getJSONObject("error_response").getString("zh_desc"));
        }
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("app_key", this.config.getClientId()).queryParam("response_type", "code").queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("scope", this.getScopes(" ", true, AuthScopeUtils.getDefaultScopes(AuthJdScope.values()))).queryParam("state", this.getRealState(state)).build();
    }
}

