/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.api.User;
import org.flowable.spring.security.FlowableUser;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class FlowableUserDetailsService
implements UserDetailsService {
    protected final IdmIdentityService identityService;

    public FlowableUserDetailsService(IdmIdentityService identityService) {
        this.identityService = identityService;
    }

    public UserDetails loadUserByUsername(String userId) throws UsernameNotFoundException {
        User user = null;
        try {
            user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
        }
        catch (FlowableException flowableException) {
            // empty catch block
        }
        if (null == user) {
            throw new UsernameNotFoundException(String.format("user (%s) could not be found", userId));
        }
        return this.createFlowableUser(user);
    }

    protected FlowableUser createFlowableUser(User user) {
        String userId = user.getId();
        List userPrivileges = this.identityService.createPrivilegeQuery().userId(userId).list();
        HashSet<SimpleGrantedAuthority> grantedAuthorities = new HashSet<SimpleGrantedAuthority>();
        for (Privilege userPrivilege : userPrivileges) {
            grantedAuthorities.add(new SimpleGrantedAuthority(userPrivilege.getName()));
        }
        List groups = this.identityService.createGroupQuery().groupMember(userId).list();
        if (!groups.isEmpty()) {
            ArrayList<String> groupIds = new ArrayList<String>(groups.size());
            for (Group group : groups) {
                groupIds.add(group.getId());
            }
            List groupPrivileges = this.identityService.createPrivilegeQuery().groupIds(groupIds).list();
            for (Privilege groupPrivilege : groupPrivileges) {
                grantedAuthorities.add(new SimpleGrantedAuthority(groupPrivilege.getName()));
            }
        }
        return new FlowableUser(user, true, groups, userPrivileges, grantedAuthorities);
    }
}

