/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.cache.provider.caffeine;

import java.time.Duration;
import org.springframework.pulsar.cache.provider.CacheProvider;
import org.springframework.pulsar.cache.provider.CacheProviderFactory;
import org.springframework.pulsar.cache.provider.caffeine.CaffeineCacheProvider;
import org.springframework.pulsar.shade.com.github.benmanes.caffeine.cache.Cache;
import org.springframework.pulsar.shade.com.github.benmanes.caffeine.cache.Caffeine;
import org.springframework.pulsar.shade.com.github.benmanes.caffeine.cache.Scheduler;

public class CaffeineCacheProviderFactory<K, V>
implements CacheProviderFactory<K, V> {
    public CacheProvider<K, V> create(Duration cacheExpireAfterAccess, Long cacheMaximumSize, Integer cacheInitialCapacity, CacheProviderFactory.EvictionListener<K, V> evictionListener) {
        Cache cache = Caffeine.newBuilder().expireAfterAccess(cacheExpireAfterAccess).maximumSize(cacheMaximumSize).initialCapacity(cacheInitialCapacity).scheduler(Scheduler.systemScheduler()).evictionListener((key, value, cause) -> evictionListener.onEviction(key, value, cause.toString())).build();
        return new CaffeineCacheProvider(cache);
    }
}

