/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TableViewBuilder;
import org.apache.pulsar.client.api.transaction.TransactionBuilder;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.core.PulsarClientBuilderCustomizer;
import org.springframework.pulsar.core.RestartableSingletonFactory;
import org.springframework.util.Assert;

final class PulsarClientProxy
extends RestartableSingletonFactory<PulsarClient>
implements PulsarClient {
    private static final int LIFECYCLE_PHASE = -1073742024;
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private final PulsarClientBuilderCustomizer customizer;

    PulsarClientProxy(PulsarClientBuilderCustomizer customizer) {
        Assert.notNull((Object)customizer, (String)"customizer must not be null");
        this.customizer = customizer;
    }

    public int getPhase() {
        return -1073742024;
    }

    @Override
    protected PulsarClient createInstance() {
        this.logger.debug(() -> "Creating client");
        ClientBuilder clientBuilder = PulsarClient.builder();
        this.customizer.customize(clientBuilder);
        try {
            return clientBuilder.build();
        }
        catch (PulsarClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void stopInstance(PulsarClient pulsarClient) {
        this.logger.debug(() -> "Closing client");
        try {
            pulsarClient.close();
        }
        catch (PulsarClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean discardInstanceAfterStop() {
        return false;
    }

    public ProducerBuilder<byte[]> newProducer() {
        return ((PulsarClient)this.getInstance()).newProducer();
    }

    public <T> ProducerBuilder<T> newProducer(Schema<T> schema) {
        return ((PulsarClient)this.getInstance()).newProducer(schema);
    }

    public ConsumerBuilder<byte[]> newConsumer() {
        return ((PulsarClient)this.getInstance()).newConsumer();
    }

    public <T> ConsumerBuilder<T> newConsumer(Schema<T> schema) {
        return ((PulsarClient)this.getInstance()).newConsumer(schema);
    }

    public ReaderBuilder<byte[]> newReader() {
        return ((PulsarClient)this.getInstance()).newReader();
    }

    public <T> ReaderBuilder<T> newReader(Schema<T> schema) {
        return ((PulsarClient)this.getInstance()).newReader(schema);
    }

    public <T> TableViewBuilder<T> newTableViewBuilder(Schema<T> schema) {
        return ((PulsarClient)this.getInstance()).newTableViewBuilder(schema);
    }

    public TableViewBuilder<byte[]> newTableView() {
        return ((PulsarClient)this.getInstance()).newTableView();
    }

    public <T> TableViewBuilder<T> newTableView(Schema<T> schema) {
        return ((PulsarClient)this.getInstance()).newTableView(schema);
    }

    public void updateServiceUrl(String serviceUrl) throws PulsarClientException {
        ((PulsarClient)this.getInstance()).updateServiceUrl(serviceUrl);
    }

    public CompletableFuture<List<String>> getPartitionsForTopic(String topic) {
        return ((PulsarClient)this.getInstance()).getPartitionsForTopic(topic);
    }

    public void close() throws PulsarClientException {
        ((PulsarClient)this.getInstance()).close();
    }

    public CompletableFuture<Void> closeAsync() {
        return ((PulsarClient)this.getInstance()).closeAsync();
    }

    public void shutdown() throws PulsarClientException {
        ((PulsarClient)this.getInstance()).shutdown();
    }

    public boolean isClosed() {
        return ((PulsarClient)this.getInstance()).isClosed();
    }

    public TransactionBuilder newTransaction() {
        return ((PulsarClient)this.getInstance()).newTransaction();
    }
}

