/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerDelegate;
import cn.crane4j.core.util.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class FilterableKeyContainer<K>
implements ContainerDelegate<K> {
    private final Container<K> container;
    private boolean filterNullKey;
    private boolean skipQueryIfKeyCollIsEmpty;

    @Override
    public Map<K, ?> get(Collection<K> keys) {
        if (this.filterNullKey && Objects.nonNull(keys)) {
            keys = keys.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.skipQueryIfKeyCollIsEmpty && CollectionUtils.isEmpty(keys) ? Collections.emptyMap() : this.container.get(keys);
    }

    public void setFilterNullKey(boolean filterNullKey) {
        this.filterNullKey = filterNullKey;
    }

    public void setSkipQueryIfKeyCollIsEmpty(boolean skipQueryIfKeyCollIsEmpty) {
        this.skipQueryIfKeyCollIsEmpty = skipQueryIfKeyCollIsEmpty;
    }

    public FilterableKeyContainer(Container<K> container) {
        this.container = container;
    }

    @Override
    public Container<K> getContainer() {
        return this.container;
    }
}

