/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.core.container.ConfigurableContainerProvider;
import cn.crane4j.core.container.Container;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PartitionContainerProvider
implements ConfigurableContainerProvider {
    private final Map<String, Container<Object>> containerMap = new HashMap<String, Container<Object>>();
    private @NonNull Function<String, Container<Object>> defaultContainerFactory = namespace -> null;

    @Override
    public <K> @Nullable Container<K> getContainer(String namespace) {
        return this.containerMap.getOrDefault(namespace, this.defaultContainerFactory.apply(namespace));
    }

    @Override
    public Object registerContainer(@NonNull Container<?> container) {
        Objects.requireNonNull(container, "Container must not null");
        return this.containerMap.put(container.getNamespace(), container);
    }

    @Override
    public boolean containsContainer(String namespace) {
        return Objects.nonNull(this.getContainer(namespace));
    }

    public void setDefaultContainerFactory(@NonNull Function<String, Container<Object>> defaultContainerFactory) {
        if (defaultContainerFactory == null) {
            throw new NullPointerException("defaultContainerFactory is marked non-null but is null");
        }
        this.defaultContainerFactory = defaultContainerFactory;
    }
}

