/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor;

import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.executor.AbstractOperationAwareBeanOperationExecutor;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.DisassembleOperation;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.MultiMap;
import java.util.Collection;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBeanOperationRecursiveExecutor
extends AbstractOperationAwareBeanOperationExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbstractBeanOperationRecursiveExecutor.class);

    protected AbstractBeanOperationRecursiveExecutor(ContainerManager containerManager) {
        super(containerManager);
    }

    @Override
    public void doExecute(@NonNull Collection<?> targets, @NonNull BeanOperations operations, BeanOperationExecutor.Options options) {
        MultiMap<BeanOperations, Object> currentTargets = MultiMap.linkedListMultimap();
        currentTargets.putAll(operations, targets);
        while (!currentTargets.isEmpty()) {
            this.executeAssembleOperations(options, currentTargets);
            MultiMap<BeanOperations, Object> nextTargets = this.executeDisassembleOperations(operations, options, currentTargets);
            this.afterOperationsCompletion(currentTargets);
            currentTargets = nextTargets;
        }
    }

    @Override
    protected MultiMap<BeanOperations, Object> doExecuteDisassembleOperations(Predicate<? super KeyTriggerOperation> filter, MultiMap<BeanOperations, Object> targetWithOps) {
        MultiMap<BeanOperations, Object> results = MultiMap.arrayListMultimap();
        targetWithOps.asMap().forEach((ops, targets) -> ops.getDisassembleOperations().stream().filter(filter).forEach(op -> this.disassembleAndCollect((Collection<Object>)targets, (DisassembleOperation)op, results)));
        return results;
    }

    private void disassembleAndCollect(Collection<Object> targets, DisassembleOperation op, MultiMap<BeanOperations, Object> collectedBeans) {
        Collection<Object> actualTarget = this.filterTargetsForSupportedOperation(targets, op);
        if (actualTarget.isEmpty()) {
            return;
        }
        DisassembleOperationHandler handler = op.getDisassembleOperationHandler();
        Collection<Object> nestedBeans = handler.process(op, targets);
        if (CollectionUtils.isNotEmpty(nestedBeans)) {
            BeanOperations beanOperations = op.getInternalBeanOperations(actualTarget);
            collectedBeans.putAll(beanOperations, nestedBeans);
        }
    }
}

