/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser.handler.strategy;

import cn.crane4j.core.parser.PropertyMapping;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategy;
import cn.crane4j.core.parser.operation.AssembleOperation;
import cn.crane4j.core.util.StringUtils;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CollJoinAsStringMappingStrategy
implements PropertyMappingStrategy {
    public static final CollJoinAsStringMappingStrategy INSTANCE = new CollJoinAsStringMappingStrategy();
    private static final String DEFAULT_DELIMITER = ",";

    @Override
    public void doMapping(AssembleOperation operation, Object target, Object source, @Nullable Object sourceValue, PropertyMapping propertyMapping, Consumer<Object> mapping) {
        if (sourceValue instanceof Collection) {
            String delimiter = StringUtils.emptyToDefault(operation.getKeyDescription(), DEFAULT_DELIMITER);
            sourceValue = ((Collection)sourceValue).stream().map(String::valueOf).collect(Collectors.joining(delimiter));
        }
        mapping.accept(sourceValue);
    }
}

