/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser.operation;

import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.DisassembleOperation;
import cn.crane4j.core.parser.operation.SimpleKeyTriggerOperation;
import cn.crane4j.core.support.TypeResolver;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDynamitedDisassembleOperation
extends SimpleKeyTriggerOperation
implements DisassembleOperation {
    private static final Logger log = LoggerFactory.getLogger(TypeDynamitedDisassembleOperation.class);
    private final Class<?> sourceType;
    private final DisassembleOperationHandler disassembleOperationHandler;
    private final BeanOperationParser beanOperationParser;
    private final TypeResolver typeResolver;

    @Override
    @NonNull
    public BeanOperations getInternalBeanOperations(Object internalBean) {
        Class<?> internalType = this.typeResolver.resolve(internalBean);
        if (Objects.isNull(internalType)) {
            log.warn("cannot resolve disassemble target type for object: [{}]", internalBean);
            return BeanOperations.empty();
        }
        return this.beanOperationParser.parse(internalType);
    }

    protected TypeDynamitedDisassembleOperation(TypeDynamitedDisassembleOperationBuilder<?, ?> b) {
        super(b);
        this.sourceType = ((TypeDynamitedDisassembleOperationBuilder)b).sourceType;
        this.disassembleOperationHandler = ((TypeDynamitedDisassembleOperationBuilder)b).disassembleOperationHandler;
        this.beanOperationParser = ((TypeDynamitedDisassembleOperationBuilder)b).beanOperationParser;
        this.typeResolver = ((TypeDynamitedDisassembleOperationBuilder)b).typeResolver;
    }

    public static TypeDynamitedDisassembleOperationBuilder<?, ?> builder() {
        return new TypeDynamitedDisassembleOperationBuilderImpl();
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public DisassembleOperationHandler getDisassembleOperationHandler() {
        return this.disassembleOperationHandler;
    }

    private static final class TypeDynamitedDisassembleOperationBuilderImpl
    extends TypeDynamitedDisassembleOperationBuilder<TypeDynamitedDisassembleOperation, TypeDynamitedDisassembleOperationBuilderImpl> {
        private TypeDynamitedDisassembleOperationBuilderImpl() {
        }

        @Override
        protected TypeDynamitedDisassembleOperationBuilderImpl self() {
            return this;
        }

        @Override
        public TypeDynamitedDisassembleOperation build() {
            return new TypeDynamitedDisassembleOperation(this);
        }
    }

    public static abstract class TypeDynamitedDisassembleOperationBuilder<C extends TypeDynamitedDisassembleOperation, B extends TypeDynamitedDisassembleOperationBuilder<C, B>>
    extends SimpleKeyTriggerOperation.SimpleKeyTriggerOperationBuilder<C, B> {
        private Class<?> sourceType;
        private DisassembleOperationHandler disassembleOperationHandler;
        private BeanOperationParser beanOperationParser;
        private TypeResolver typeResolver;

        public B sourceType(Class<?> sourceType) {
            this.sourceType = sourceType;
            return (B)this.self();
        }

        public B disassembleOperationHandler(DisassembleOperationHandler disassembleOperationHandler) {
            this.disassembleOperationHandler = disassembleOperationHandler;
            return (B)this.self();
        }

        public B beanOperationParser(BeanOperationParser beanOperationParser) {
            this.beanOperationParser = beanOperationParser;
            return (B)this.self();
        }

        public B typeResolver(TypeResolver typeResolver) {
            this.typeResolver = typeResolver;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TypeDynamitedDisassembleOperation.TypeDynamitedDisassembleOperationBuilder(super=" + super.toString() + ", sourceType=" + this.sourceType + ", disassembleOperationHandler=" + this.disassembleOperationHandler + ", beanOperationParser=" + this.beanOperationParser + ", typeResolver=" + this.typeResolver + ")";
        }
    }
}

