/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.aop;

import cn.crane4j.annotation.ArgAutoOperate;
import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.ParameterNameFinder;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElement;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.expression.MethodBasedExpressionEvaluator;
import cn.crane4j.core.util.ArrayUtils;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodArgumentAutoOperateSupport {
    private static final Logger log = LoggerFactory.getLogger(MethodArgumentAutoOperateSupport.class);
    protected static final AutoOperateAnnotatedElement[] EMPTY_ELEMENTS = new AutoOperateAnnotatedElement[0];
    protected final AutoOperateAnnotatedElementResolver elementResolver;
    protected final Map<Method, AutoOperateAnnotatedElement[]> methodParameterCaches = CollectionUtils.newWeakConcurrentMap();
    protected final ParameterNameFinder parameterNameFinder;
    protected final AnnotationFinder annotationFinder;
    protected final MethodBasedExpressionEvaluator expressionEvaluator;

    public MethodArgumentAutoOperateSupport(AutoOperateAnnotatedElementResolver elementResolver, MethodBasedExpressionEvaluator expressionEvaluator, ParameterNameFinder parameterNameFinder, AnnotationFinder annotationFinder) {
        this.elementResolver = elementResolver;
        this.annotationFinder = annotationFinder;
        this.parameterNameFinder = parameterNameFinder;
        this.expressionEvaluator = expressionEvaluator;
    }

    public final void beforeMethodInvoke(Method method, Object[] args) {
        if (ArrayUtils.isEmpty(args)) {
            return;
        }
        AutoOperateAnnotatedElement[] elements = CollectionUtils.computeIfAbsent(this.methodParameterCaches, method, this::resolveParameters);
        if (elements == EMPTY_ELEMENTS) {
            return;
        }
        log.debug("process arguments for [{}]", (Object)method.getName());
        this.processArguments(method, args, elements);
    }

    protected void processArguments(Method method, Object[] args, AutoOperateAnnotatedElement[] autoOperateAnnotatedElements) {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            AutoOperateAnnotatedElement element = autoOperateAnnotatedElements[i];
            if (!Objects.nonNull(element) || !this.canApply(method, args, element.getAnnotation().condition())) continue;
            element.execute(arg);
        }
    }

    protected AutoOperateAnnotatedElement[] resolveParameters(Method method) {
        if (method.getParameterCount() < 1) {
            log.warn("cannot apply auto operate for method [{}], because it has no parameters", (Object)method);
            return EMPTY_ELEMENTS;
        }
        Map<String, AutoOperate> methodLevelAnnotations = this.resolveMethodLevelAnnotations(method);
        Map<String, Parameter> parameterMap = ReflectUtils.resolveParameterNames(this.parameterNameFinder, method);
        AutoOperateAnnotatedElement[] results = new AutoOperateAnnotatedElement[parameterMap.size()];
        int index = 0;
        for (Map.Entry<String, Parameter> entry : parameterMap.entrySet()) {
            String paramName = entry.getKey();
            Parameter param = entry.getValue();
            AutoOperate annotation = Optional.ofNullable(this.annotationFinder.getAnnotation(param, AutoOperate.class)).orElse(methodLevelAnnotations.get(paramName));
            results[index++] = Objects.isNull(annotation) ? null : this.elementResolver.resolve(param, annotation);
        }
        if (Stream.of(results).allMatch(Objects::isNull)) {
            log.warn("cannot apply auto operate for method [{}], because all parameters have no operation configuration", (Object)method);
            return EMPTY_ELEMENTS;
        }
        return results;
    }

    private @NonNull Map<String, AutoOperate> resolveMethodLevelAnnotations(Method method) {
        return Optional.ofNullable(this.annotationFinder.findAnnotation(method, ArgAutoOperate.class)).map(ArgAutoOperate::value).map(Arrays::stream).map(annotations -> annotations.map(a -> this.checkMethodLevelAnnotation(method, (AutoOperate)a)).collect(Collectors.toMap(AutoOperate::value, Function.identity()))).orElseGet(Collections::emptyMap);
    }

    public void destroy() {
        for (Object[] objectArray : this.methodParameterCaches.values()) {
            Arrays.fill(objectArray, null);
        }
        this.methodParameterCaches.clear();
    }

    private boolean canApply(Method method, Object[] args, String condition) {
        return StringUtils.isEmpty(condition) || Boolean.TRUE.equals(this.expressionEvaluator.execute(condition, Boolean.class, method, args, null));
    }

    private AutoOperate checkMethodLevelAnnotation(Method method, AutoOperate autoOperate) {
        Asserts.isNotEmpty(autoOperate.value(), "Method level @AutoOperate annotation must bind to method parameter by attribute 'value': [{}]", method);
        return autoOperate;
    }
}

