/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.aop;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElement;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.expression.MethodBasedExpressionEvaluator;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodResultAutoOperateSupport {
    private static final Logger log = LoggerFactory.getLogger(MethodResultAutoOperateSupport.class);
    protected final Map<Method, AutoOperateAnnotatedElement> methodCaches = CollectionUtils.newWeakConcurrentMap();
    protected final AutoOperateAnnotatedElementResolver elementResolver;
    protected final MethodBasedExpressionEvaluator expressionEvaluator;
    protected final AnnotationFinder annotationFinder;

    public void afterMethodInvoke(Method method, Object result, Object[] args) {
        if (Objects.isNull(result)) {
            return;
        }
        log.debug("process result for [{}]", (Object)method);
        AutoOperateAnnotatedElement element = CollectionUtils.computeIfAbsent(this.methodCaches, method, this::resolveReturn);
        if (element == AutoOperateAnnotatedElement.EMPTY) {
            return;
        }
        String condition = element.getAnnotation().condition();
        if (this.support(method, result, args, condition)) {
            element.execute(result);
        }
    }

    protected @NonNull AutoOperateAnnotatedElement resolveReturn(Method method) {
        if (Objects.equals(Void.TYPE, method.getReturnType())) {
            log.warn("cannot apply auto operate for method [{}], because return type is void", (Object)method);
            return AutoOperateAnnotatedElement.EMPTY;
        }
        return Optional.ofNullable(this.annotationFinder.findAnnotation(method, AutoOperate.class)).map(annotation -> this.elementResolver.resolve(method, (AutoOperate)annotation)).orElse(AutoOperateAnnotatedElement.EMPTY);
    }

    public void destroy() {
        this.methodCaches.clear();
    }

    private boolean support(Method method, Object result, Object[] args, String condition) {
        return StringUtils.isEmpty(condition) || Boolean.TRUE.equals(this.expressionEvaluator.execute(condition, Boolean.class, method, args, result));
    }

    public MethodResultAutoOperateSupport(AutoOperateAnnotatedElementResolver elementResolver, MethodBasedExpressionEvaluator expressionEvaluator, AnnotationFinder annotationFinder) {
        this.elementResolver = elementResolver;
        this.expressionEvaluator = expressionEvaluator;
        this.annotationFinder = annotationFinder;
    }
}

