/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.auto;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Grouped;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElement;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractAutoOperateAnnotatedElementResolver
implements AutoOperateAnnotatedElementResolver {
    protected final Crane4jGlobalConfiguration configuration;

    @Override
    public @Nullable AutoOperateAnnotatedElement resolve(@NonNull AnnotatedElement element, AutoOperate annotation) {
        Asserts.isNotNull(element, "element must not be null", new Object[0]);
        Asserts.isNotNull(annotation, "annotation must not be null", new Object[0]);
        MethodInvoker extractor = this.resolveExtractor(element, annotation);
        BeanOperationParser parser = this.configuration.getBeanOperationsParser(annotation.parser(), annotation.parserType());
        BeanOperationExecutor executor = this.configuration.getBeanOperationExecutor(annotation.executor(), annotation.executorType());
        Predicate<? super KeyTriggerOperation> filter = this.resolveFilter(annotation);
        return this.createAutoOperateAnnotatedElement(element, annotation, parser, executor, extractor, filter);
    }

    protected abstract @Nullable AutoOperateAnnotatedElement createAutoOperateAnnotatedElement(AnnotatedElement var1, AutoOperate var2, BeanOperationParser var3, BeanOperationExecutor var4, MethodInvoker var5, Predicate<? super KeyTriggerOperation> var6);

    protected abstract MethodInvoker resolveExtractor(AnnotatedElement var1, AutoOperate var2);

    protected Predicate<? super KeyTriggerOperation> resolveFilter(AutoOperate annotation) {
        Set excludes = CollectionUtils.newCollection(HashSet::new, annotation.excludes());
        Set includes = CollectionUtils.newCollection(HashSet::new, annotation.includes());
        includes.removeAll(excludes);
        if (includes.isEmpty()) {
            return Grouped.noneMatch(annotation.excludes());
        }
        if (excludes.isEmpty()) {
            return Grouped.anyMatch(annotation.includes());
        }
        return t -> CollectionUtils.containsAny(includes, t.getGroups()) || CollectionUtils.notContainsAny(excludes, t.getGroups());
    }

    public AbstractAutoOperateAnnotatedElementResolver(Crane4jGlobalConfiguration configuration) {
        this.configuration = configuration;
    }
}

