/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.expression;

import cn.crane4j.core.exception.Crane4jException;
import cn.crane4j.core.support.expression.ExpressionContext;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.crane4j.core.support.expression.OgnlExpressionContext;
import cn.crane4j.core.util.CollectionUtils;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OgnlExpressionEvaluator
implements ExpressionEvaluator {
    private final Map<String, Object> expressionCaches = CollectionUtils.newWeakConcurrentMap();

    @Override
    public <T> @Nullable T execute(String expression, Class<T> resultType, ExpressionContext context) {
        Object exp = CollectionUtils.computeIfAbsent(this.expressionCaches, expression, ex -> {
            Object result;
            try {
                result = Ognl.parseExpression((String)ex);
            }
            catch (OgnlException e) {
                throw new Crane4jException(e);
            }
            return result;
        });
        OgnlContext ognlContext = context instanceof OgnlContext ? (OgnlContext)context : new OgnlExpressionContext(context);
        return (T)Ognl.getValue((Object)exp, (Map)ognlContext, (Object)ognlContext.getRoot(), resultType);
    }
}

