/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.operator;

import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.operator.OperatorProxyMethodFactory;
import cn.crane4j.core.util.ArrayUtils;
import cn.crane4j.core.util.CollectionUtils;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParametersFillProxyMethodFactory
implements OperatorProxyMethodFactory {
    private static final Logger log = LoggerFactory.getLogger(ParametersFillProxyMethodFactory.class);
    private final BeanOperationParser beanOperationParser;

    @Override
    public int getSort() {
        return 3;
    }

    @Override
    public @Nullable MethodInvoker get(BeanOperations beanOperations, Method method, BeanOperationExecutor beanOperationExecutor) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return null;
        }
        BeanOperations[] beanOperationsArray = new BeanOperations[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            BeanOperations bo = this.beanOperationParser.parse(parameterType);
            beanOperationsArray[i] = bo.isEmpty() ? null : bo;
        }
        return new ParameterFillMethodInvoker(beanOperationsArray, beanOperationExecutor);
    }

    public ParametersFillProxyMethodFactory(BeanOperationParser beanOperationParser) {
        this.beanOperationParser = beanOperationParser;
    }

    private static class ParameterFillMethodInvoker
    implements MethodInvoker {
        private final BeanOperations[] beanOperations;
        private final BeanOperationExecutor executor;

        @Override
        public Object invoke(Object target, Object ... args) {
            if (ArrayUtils.isNotEmpty(args)) {
                for (int i = 0; i < args.length; ++i) {
                    this.doInvoke(args, i);
                }
            }
            return null;
        }

        private void doInvoke(Object[] args, int i) {
            Object arg = args[i];
            if (arg == null) {
                return;
            }
            BeanOperations bo = this.beanOperations[i];
            if (bo == null) {
                return;
            }
            this.executor.execute(CollectionUtils.adaptObjectToCollection(arg), bo);
        }

        public ParameterFillMethodInvoker(BeanOperations[] beanOperations, BeanOperationExecutor executor) {
            this.beanOperations = beanOperations;
            this.executor = executor;
        }
    }
}

