/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.reflect.PropDesc;
import cn.crane4j.core.support.reflect.ReflectivePropertyOperator;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.core.util.Try;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodHandlePropertyOperator
extends ReflectivePropertyOperator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandlePropertyOperator.class);

    public MethodHandlePropertyOperator(@Nullable ConverterManager converterManager) {
        super(converterManager);
    }

    @Override
    public @NonNull PropDesc getPropertyDescriptor(Class<?> targetType) {
        return new MethodHandlePropDesc(targetType, this.converterManager, this.throwIfNoAnyMatched);
    }

    public MethodHandlePropertyOperator() {
    }

    public static class MethodHandleGetter
    implements MethodInvoker {
        private final MethodHandle methodHandle;

        @Override
        public Object invoke(Object target, Object ... args) {
            return this.methodHandle.bindTo(target).invoke();
        }

        public MethodHandleGetter(MethodHandle methodHandle) {
            this.methodHandle = methodHandle;
        }
    }

    public static class MethodHandleSetter
    implements MethodInvoker {
        private final MethodHandle methodHandle;

        @Override
        public Object invoke(Object target, Object ... args) {
            return this.methodHandle.bindTo(target).invokeWithArguments(args);
        }

        public MethodHandleSetter(MethodHandle methodHandle) {
            this.methodHandle = methodHandle;
        }
    }

    private static class MethodHandlePropDesc
    extends ReflectivePropertyOperator.ReflectivePropDesc {
        public MethodHandlePropDesc(Class<?> beanType, @Nullable ConverterManager converterManager, boolean throwIfNoAnyMatched) {
            super(beanType, converterManager, throwIfNoAnyMatched);
        }

        @Override
        protected MethodInvoker createSetterInvokerForField(String propertyName, Field field) {
            if (Modifier.isStatic(field.getModifiers())) {
                return super.createSetterInvokerForField(propertyName, field);
            }
            return Try.of(() -> {
                ReflectUtils.setAccessible(field);
                MethodHandle handle = MethodHandles.lookup().unreflectSetter(field);
                return new MethodHandleSetter(handle);
            }).getOrElseGet(e -> {
                log.warn("cannot find method handle of setter for field: {}", (Object)field, e);
                return super.createSetterInvokerForField(propertyName, field);
            });
        }

        @Override
        protected MethodInvoker createGetterInvokerForField(String propertyName, Field field) {
            if (Modifier.isStatic(field.getModifiers())) {
                return super.createGetterInvokerForField(propertyName, field);
            }
            return Try.of(() -> {
                ReflectUtils.setAccessible(field);
                MethodHandle handle = MethodHandles.lookup().unreflectGetter(field);
                return new MethodHandleGetter(handle);
            }).getOrElseGet(e -> {
                log.debug("cannot find method handle of getter for field: {}", (Object)field, e);
                return super.createGetterInvokerForField(propertyName, field);
            });
        }

        @Override
        protected @Nullable MethodInvoker createInvokerForMethod(String propertyName, Method method) {
            return Try.of(() -> {
                ReflectUtils.setAccessible(method);
                MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
                return method.getParameterCount() > 0 ? new MethodHandleSetter(methodHandle) : new MethodHandleGetter(methodHandle);
            }).getOrElseGet(e -> {
                log.debug("cannot find method handle of getter method: {}", (Object)method, e);
                return super.createInvokerForMethod(propertyName, method);
            });
        }
    }
}

