/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.core.support.converter.ConverterManager;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.core.convert.ConversionService;

public class SpringConverterManager
implements ConverterManager {
    private final ConversionService conversionService;

    public <T, R> @Nullable BiFunction<T, R, R> getConverter(Class<T> targetType, Class<R> resultType) {
        return (target, def) -> {
            try {
                return this.conversionService.convert(target, resultType);
            }
            catch (Exception e) {
                return def;
            }
        };
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public SpringConverterManager(ConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

