/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.expression;

import cn.crane4j.core.support.expression.ExpressionContext;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.extension.spring.expression.SpelExpressionContext;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.util.StringValueResolver;

public class SpelExpressionEvaluator
implements ExpressionEvaluator,
DisposableBean,
EmbeddedValueResolverAware {
    private final Map<String, Expression> expressionCaches = CollectionUtils.newWeakConcurrentMap();
    private final ExpressionParser expressionParser;
    private StringValueResolver embeddedValueResolver;

    public <T> @Nullable T execute(String expression, Class<T> resultType, ExpressionContext context) {
        expression = Objects.isNull(this.embeddedValueResolver) ? expression : this.embeddedValueResolver.resolveStringValue(expression);
        Object evaluationContext = context instanceof SpelExpressionContext ? (EvaluationContext)context : new SpelExpressionContext(context);
        return (T)this.parseExpression(expression).getValue(evaluationContext, resultType);
    }

    public void destroy() {
        this.expressionCaches.clear();
    }

    private Expression parseExpression(String expression) {
        return (Expression)CollectionUtils.computeIfAbsent(this.expressionCaches, (Object)expression, arg_0 -> ((ExpressionParser)this.expressionParser).parseExpression(arg_0));
    }

    public SpelExpressionEvaluator(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public void setEmbeddedValueResolver(StringValueResolver embeddedValueResolver) {
        this.embeddedValueResolver = embeddedValueResolver;
    }
}

