/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.spring.boot.config;

import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.reflect.DecoratedPropertyOperator;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.extension.jackson.JacksonJsonNodeAssistant;
import cn.crane4j.extension.jackson.JsonNodeAssistant;
import cn.crane4j.extension.jackson.JsonNodeAutoOperateModule;
import cn.crane4j.extension.jackson.JsonNodePropertyOperator;
import cn.crane4j.spring.boot.config.Crane4jAutoConfiguration;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={Crane4jAutoConfiguration.class})
@ConditionalOnClass(value={ObjectMapper.class, JsonNodeAssistant.class})
public class Crane4jJacksonConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Crane4jJacksonConfiguration.class);

    @ConditionalOnMissingBean
    @Bean
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @ConditionalOnMissingBean
    @Bean
    public JsonNodeAssistant<JsonNode> jacksonJsonNodeAssistant(ObjectMapper objectMapper) {
        return new JacksonJsonNodeAssistant(objectMapper);
    }

    @Bean
    public JsonNodeAutoOperateModule jsonNodeAutoOperateModule(AutoOperateAnnotatedElementResolver elementResolver, AnnotationFinder annotationFinder, ObjectMapper objectMapper) {
        return new JsonNodeAutoOperateModule(elementResolver, objectMapper, annotationFinder);
    }

    @Bean
    public Initializer initializer(ApplicationContext applicationContext, JsonNodeAssistant<JsonNode> assistant, JsonNodeAutoOperateModule jsonNodeAutoOperateModule) {
        return new Initializer(applicationContext, jsonNodeAutoOperateModule, assistant);
    }

    public static class Initializer
    implements ApplicationRunner {
        private final ApplicationContext applicationContext;
        private final JsonNodeAutoOperateModule jsonNodeAutoOperateModule;
        private final JsonNodeAssistant<JsonNode> assistant;

        public void run(ApplicationArguments args) {
            this.registerModule();
            this.wrapPropertyOperatorIfNecessary();
            log.info("crane4j jackson extension component initialization completed.");
        }

        private void wrapPropertyOperatorIfNecessary() {
            PropertyOperator propertyOperator = (PropertyOperator)this.applicationContext.getBean(PropertyOperator.class);
            if (!(propertyOperator instanceof DecoratedPropertyOperator)) {
                log.warn("cannot wrap an existing PropertyOperator as a {}, make sure the instance that exists in the spring container is {}", (Object)JsonNodePropertyOperator.class.getSimpleName(), (Object)DecoratedPropertyOperator.class.getSimpleName());
                return;
            }
            DecoratedPropertyOperator decorated = (DecoratedPropertyOperator)propertyOperator;
            decorated.setPropertyOperator((PropertyOperator)new JsonNodePropertyOperator(this.assistant, decorated.getPropertyOperator()));
        }

        private void registerModule() {
            try {
                ObjectMapper objectMapper = (ObjectMapper)this.applicationContext.getBean(ObjectMapper.class);
                if (!objectMapper.getRegisteredModuleIds().contains(JsonNodeAutoOperateModule.MODULE_NAME)) {
                    objectMapper.registerModule((Module)this.jsonNodeAutoOperateModule);
                    log.info("register module [{}] from ObjectMapper", (Object)JsonNodeAutoOperateModule.MODULE_NAME);
                }
            }
            catch (Exception e) {
                log.warn("unable to automatically register module [{}] because ObjectMapper could not be found,or there are multiple ObjectMapper but primary bean is not specified,please manually register xx to the specified instance", (Object)JsonNodeAutoOperateModule.class.getSimpleName());
            }
        }

        public Initializer(ApplicationContext applicationContext, JsonNodeAutoOperateModule jsonNodeAutoOperateModule, JsonNodeAssistant<JsonNode> assistant) {
            this.applicationContext = applicationContext;
            this.jsonNodeAutoOperateModule = jsonNodeAutoOperateModule;
            this.assistant = assistant;
        }
    }
}

