/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.metadata.csv;

import cn.idev.excel.metadata.csv.CsvCell;
import cn.idev.excel.metadata.csv.CsvSheet;
import cn.idev.excel.metadata.csv.CsvWorkbook;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class CsvRow
implements Row {
    private final List<CsvCell> cellList = Lists.newArrayList();
    private final CsvWorkbook csvWorkbook;
    private final CsvSheet csvSheet;
    private Integer rowIndex;
    private CellStyle cellStyle;

    public CsvRow(CsvWorkbook csvWorkbook, CsvSheet csvSheet, Integer rowIndex) {
        this.csvWorkbook = csvWorkbook;
        this.csvSheet = csvSheet;
        this.rowIndex = rowIndex;
    }

    public Cell createCell(int column) {
        CsvCell cell = new CsvCell(this.csvWorkbook, this.csvSheet, this, column, null);
        this.cellList.add(cell);
        return cell;
    }

    public Cell createCell(int column, CellType type) {
        CsvCell cell = new CsvCell(this.csvWorkbook, this.csvSheet, this, column, type);
        this.cellList.add(cell);
        return cell;
    }

    public void removeCell(Cell cell) {
        this.cellList.remove(cell);
    }

    public void setRowNum(int rowNum) {
        this.rowIndex = rowNum;
    }

    public int getRowNum() {
        return this.rowIndex;
    }

    public Cell getCell(int cellnum) {
        if (cellnum >= this.cellList.size()) {
            return null;
        }
        return (Cell)this.cellList.get(cellnum - 1);
    }

    public Cell getCell(int cellnum, Row.MissingCellPolicy policy) {
        return this.getCell(cellnum);
    }

    public short getFirstCellNum() {
        if (CollectionUtils.isEmpty(this.cellList)) {
            return -1;
        }
        return 0;
    }

    public short getLastCellNum() {
        if (CollectionUtils.isEmpty(this.cellList)) {
            return -1;
        }
        return (short)this.cellList.size();
    }

    public int getPhysicalNumberOfCells() {
        return this.getRowNum();
    }

    public void setHeight(short height) {
    }

    public void setZeroHeight(boolean zHeight) {
    }

    public boolean getZeroHeight() {
        return false;
    }

    public void setHeightInPoints(float height) {
    }

    public short getHeight() {
        return 0;
    }

    public float getHeightInPoints() {
        return 0.0f;
    }

    public boolean isFormatted() {
        return false;
    }

    public CellStyle getRowStyle() {
        return this.cellStyle;
    }

    public void setRowStyle(CellStyle style) {
        this.cellStyle = style;
    }

    public Iterator<Cell> cellIterator() {
        return this.cellList.iterator();
    }

    public Sheet getSheet() {
        return this.csvSheet;
    }

    public int getOutlineLevel() {
        return 0;
    }

    public void shiftCellsRight(int firstShiftColumnIndex, int lastShiftColumnIndex, int step) {
    }

    public void shiftCellsLeft(int firstShiftColumnIndex, int lastShiftColumnIndex, int step) {
    }

    public Iterator<Cell> iterator() {
        return this.cellIterator();
    }

    public List<CsvCell> getCellList() {
        return this.cellList;
    }

    public CsvWorkbook getCsvWorkbook() {
        return this.csvWorkbook;
    }

    public CsvSheet getCsvSheet() {
        return this.csvSheet;
    }

    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsvRow)) {
            return false;
        }
        CsvRow other = (CsvRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$rowIndex = this.getRowIndex();
        Integer other$rowIndex = other.getRowIndex();
        if (this$rowIndex == null ? other$rowIndex != null : !((Object)this$rowIndex).equals(other$rowIndex)) {
            return false;
        }
        List<CsvCell> this$cellList = this.getCellList();
        List<CsvCell> other$cellList = other.getCellList();
        if (this$cellList == null ? other$cellList != null : !((Object)this$cellList).equals(other$cellList)) {
            return false;
        }
        CsvWorkbook this$csvWorkbook = this.getCsvWorkbook();
        CsvWorkbook other$csvWorkbook = other.getCsvWorkbook();
        if (this$csvWorkbook == null ? other$csvWorkbook != null : !((Object)this$csvWorkbook).equals(other$csvWorkbook)) {
            return false;
        }
        CsvSheet this$csvSheet = this.getCsvSheet();
        CsvSheet other$csvSheet = other.getCsvSheet();
        if (this$csvSheet == null ? other$csvSheet != null : !((Object)this$csvSheet).equals(other$csvSheet)) {
            return false;
        }
        CellStyle this$cellStyle = this.getCellStyle();
        CellStyle other$cellStyle = other.getCellStyle();
        return !(this$cellStyle == null ? other$cellStyle != null : !this$cellStyle.equals(other$cellStyle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CsvRow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $rowIndex = this.getRowIndex();
        result = result * 59 + ($rowIndex == null ? 43 : ((Object)$rowIndex).hashCode());
        List<CsvCell> $cellList = this.getCellList();
        result = result * 59 + ($cellList == null ? 43 : ((Object)$cellList).hashCode());
        CsvWorkbook $csvWorkbook = this.getCsvWorkbook();
        result = result * 59 + ($csvWorkbook == null ? 43 : ((Object)$csvWorkbook).hashCode());
        CsvSheet $csvSheet = this.getCsvSheet();
        result = result * 59 + ($csvSheet == null ? 43 : ((Object)$csvSheet).hashCode());
        CellStyle $cellStyle = this.getCellStyle();
        result = result * 59 + ($cellStyle == null ? 43 : $cellStyle.hashCode());
        return result;
    }
}

