/*
 * Decompiled with CFR 0.152.
 */
package cn.sticki.spel.validator.core.parse;

import cn.sticki.spel.validator.core.exception.SpelParserException;
import cn.sticki.spel.validator.core.parse.SpelValidatorBeanRegistrar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpelParser.class);
    private static final SpelExpressionParser parser = new SpelExpressionParser();
    private static final StandardEvaluationContext context = new StandardEvaluationContext();
    private static final Map<String, Expression> expressionCache = new ConcurrentHashMap<String, Expression>();

    private SpelParser() {
    }

    private static void init() {
        ApplicationContext applicationContext = SpelValidatorBeanRegistrar.getApplicationContext();
        if (applicationContext != null) {
            AutowireCapableBeanFactory beanFactory = applicationContext.getAutowireCapableBeanFactory();
            context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)beanFactory));
        } else {
            log.info("ApplicationContext is null, SpelParser will not support spring bean reference");
            log.info("If you want to use spring bean reference in SpelParser, please use @EnableSpelValidatorBeanRegistrar to enable ApplicationContext support");
        }
        log.debug("SpelParser init success");
    }

    @Nullable
    public static Object parse(@Language(value="spel") String expression, Object rootObject) {
        try {
            log.debug("======> Parse expression [{}]", (Object)expression);
            Expression parsed = expressionCache.computeIfAbsent(expression, arg_0 -> ((SpelExpressionParser)parser).parseExpression(arg_0));
            Object value = parsed.getValue((EvaluationContext)context, rootObject, Object.class);
            log.debug("======> Parse result [{}]", value);
            return value;
        }
        catch (RuntimeException e) {
            throw new SpelParserException("Parse expression error, expression [" + expression + "], message [" + e.getMessage() + "]", e);
        }
    }

    @NotNull
    public static <T> T parse(@Language(value="spel") String expression, Object rootObject, Class<T> requiredType) {
        Object any = SpelParser.parse(expression, rootObject);
        if (any == null) {
            throw new SpelParserException("Expression [" + expression + "] calculate result can not be null");
        }
        if (!requiredType.isInstance(any)) {
            throw new SpelParserException("Expression [" + expression + "] calculate result must be [" + requiredType.getName() + "]");
        }
        return (T)any;
    }

    static {
        SpelParser.init();
    }
}

