/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.rpc.okhttp;

import com.aizuda.snailjob.server.common.rpc.okhttp.OkHttp3ClientHttpRequest;
import java.io.IOException;
import java.net.URI;
import okhttp3.Cache;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.Assert;

public class OkHttp3ClientHttpRequestFactory
implements ClientHttpRequestFactory,
DisposableBean {
    private OkHttpClient client;

    public OkHttp3ClientHttpRequestFactory(OkHttpClient client) {
        Assert.notNull((Object)client, (String)"OkHttpClient must not be null");
        this.client = client;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) {
        return new OkHttp3ClientHttpRequest(this.client, uri, httpMethod);
    }

    public void destroy() throws IOException {
        Cache cache = this.client.cache();
        if (cache != null) {
            cache.close();
        }
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
    }
}

