/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.curd.controller;

import com.anji.plus.gaea.annotation.AccessKey;
import com.anji.plus.gaea.annotation.DetailView;
import com.anji.plus.gaea.annotation.Permission;
import com.anji.plus.gaea.annotation.log.GaeaAuditLog;
import com.anji.plus.gaea.bean.ResponseBean;
import com.anji.plus.gaea.curd.controller.BaseResponse;
import com.anji.plus.gaea.curd.dto.BaseDTO;
import com.anji.plus.gaea.curd.entity.GaeaBaseEntity;
import com.anji.plus.gaea.curd.params.PageParam;
import com.anji.plus.gaea.curd.service.GaeaBaseService;
import com.anji.plus.gaea.holder.UserContentHolder;
import com.anji.plus.gaea.utils.GaeaBeanUtils;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class GaeaBaseController<P extends PageParam, T extends GaeaBaseEntity, D extends BaseDTO>
extends BaseResponse {
    public abstract GaeaBaseService<P, T> getService();

    public abstract T getEntity();

    public abstract D getDTO();

    @GetMapping(value={"/pageList"})
    @Permission(code="query", name="\u67e5\u8be2")
    @GaeaAuditLog(pageTitle="\u67e5\u8be2", isSaveResponseData=false)
    public ResponseBean pageList(P param) {
        IPage<T> iPage = this.getService().page(param);
        List records = iPage.getRecords();
        List<?> list = GaeaBeanUtils.copyList(records, this.getDTO().getClass());
        this.pageResultHandler(list);
        Page pageDto = new Page();
        pageDto.setCurrent(iPage.getCurrent()).setRecords(list).setPages(iPage.getPages()).setTotal(iPage.getTotal()).setSize(iPage.getSize());
        return this.responseSuccessWithData(pageDto);
    }

    public List<D> pageResultHandler(List<D> list) {
        return list;
    }

    public D detailResultHandler(D detail) {
        return detail;
    }

    @GetMapping(value={"/{id}"})
    @Permission(code="detail", name="\u660e\u7ec6")
    @AccessKey
    @DetailView
    public ResponseBean detail(@PathVariable(value="id") Long id) {
        GaeaBaseEntity result = (GaeaBaseEntity)this.getService().selectOne(id);
        D dto = this.getDTO();
        GaeaBeanUtils.copyAndFormatter(result, dto);
        this.detailResultHandler(dto);
        ResponseBean responseBean = this.responseSuccessWithData(this.resultDtoHandle(dto));
        this.logger.info("\u6839\u636eID\u67e5\u8be2\u7ed3\u675f\uff0creq\uff1a{},res:{}", (Object)id, (Object)responseBean);
        return responseBean;
    }

    protected D resultDtoHandle(D d) {
        return d;
    }

    @PostMapping
    @Permission(code="insert", name="\u65b0\u589e")
    @GaeaAuditLog(pageTitle="\u65b0\u589e")
    public ResponseBean insert(@Validated @RequestBody D dto) {
        Object entity = this.getEntity();
        BeanUtils.copyProperties(dto, entity);
        this.getService().insert(entity);
        ResponseBean ret = this.responseSuccessWithData(entity.copyTo(dto.getClass()));
        this.logger.info("\u65b0\u589e\u670d\u52a1\u7ed3\u675f\uff0creq\uff1a{},res:{}", dto, (Object)ret);
        return ret;
    }

    @PutMapping
    @Permission(code="update", name="\u4fee\u6539")
    @GaeaAuditLog(pageTitle="\u4fee\u6539")
    public ResponseBean update(@Validated @RequestBody D dto) {
        String username = UserContentHolder.getContext().getUsername();
        Object entity = this.getEntity();
        BeanUtils.copyProperties(dto, entity);
        this.getService().update(entity);
        this.logger.info("\u66f4\u65b0\u670d\u52a1\u7ed3\u675f\uff0cuser:{},req:{},res:{}", new Object[]{username, dto, entity});
        ResponseBean ret = this.responseSuccessWithData(entity.copyTo(dto.getClass()));
        return ret;
    }

    @DeleteMapping(value={"/{id}"})
    @Permission(code="delete", name="\u5220\u9664")
    @GaeaAuditLog(pageTitle="\u5220\u9664")
    public ResponseBean deleteById(@PathVariable(value="id") Long id) {
        this.getService().deleteById(id);
        this.logger.info("\u5220\u9664\u670d\u52a1\u7ed3\u675f:{}", (Object)id);
        return this.responseSuccess();
    }

    @PostMapping(value={"/delete/batch"})
    @Permission(code="deleteBatch", name="\u6279\u91cf\u5220\u9664")
    @GaeaAuditLog(pageTitle="\u6279\u91cf\u5220\u9664")
    public ResponseBean deleteBatchIds(@RequestBody List<Serializable> ids) {
        boolean deleteCount = this.getService().deleteByIds(ids);
        ResponseBean responseBean = this.responseSuccessWithData(deleteCount);
        this.logger.info("\u6279\u91cf\u5220\u9664\u670d\u52a1\u7ed3\u675f\uff0creq:{},ret\uff1a{}", ids, (Object)responseBean);
        return responseBean;
    }
}

