/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDataProcessor;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.data.ClickHousePipedStream;
import com.clickhouse.client.data.ClickHouseRowBinaryProcessor;
import com.clickhouse.client.data.ClickHouseTabSeparatedProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class ClickHouseDataStreamFactory {
    private static final ClickHouseDataStreamFactory instance = ClickHouseUtils.getService(ClickHouseDataStreamFactory.class, new ClickHouseDataStreamFactory());

    public static ClickHouseDataStreamFactory getInstance() {
        return instance;
    }

    public ClickHouseDataProcessor getProcessor(ClickHouseConfig config, ClickHouseInputStream input, OutputStream output, Map<String, Object> settings, List<ClickHouseColumn> columns) throws IOException {
        ClickHouseDataProcessor processor;
        ClickHouseFormat format = ClickHouseChecker.nonNull(config, "config").getFormat();
        if (ClickHouseFormat.RowBinary == format || ClickHouseFormat.RowBinaryWithNamesAndTypes == format) {
            processor = new ClickHouseRowBinaryProcessor(config, input, output, columns, settings);
        } else if (ClickHouseFormat.TSVWithNames == format || ClickHouseFormat.TSVWithNamesAndTypes == format || ClickHouseFormat.TabSeparatedWithNames == format || ClickHouseFormat.TabSeparatedWithNamesAndTypes == format) {
            processor = new ClickHouseTabSeparatedProcessor(config, input, output, columns, settings);
        } else if (format != null && format.isText()) {
            processor = new ClickHouseTabSeparatedProcessor(config, input, output, ClickHouseDataProcessor.DEFAULT_COLUMNS, settings);
        } else {
            throw new IllegalArgumentException("Unsupported format: " + (Object)((Object)format));
        }
        return processor;
    }

    public ClickHousePipedStream createPipedStream(ClickHouseConfig config) {
        ClickHouseChecker.nonNull(config, "config");
        return new ClickHousePipedStream(config.getMaxBufferSize(), config.getMaxQueuedBuffers(), config.getSocketTimeout());
    }
}

