/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDataProcessor;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseRecord;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.data.ClickHouseStringValue;
import com.clickhouse.client.data.tsv.ByteFragment;
import com.clickhouse.client.data.tsv.StreamSplitter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ClickHouseTabSeparatedProcessor
extends ClickHouseDataProcessor {
    private final byte rowDelimitter = (byte)10;
    private byte colDelimitter;
    private StreamSplitter splitter;

    private static String[] toStringArray(ByteFragment headerFragment, byte delimitter) {
        if (delimitter == 0) {
            return new String[]{headerFragment.asString(true)};
        }
        ByteFragment[] split = headerFragment.split(delimitter);
        String[] array = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            array[i] = split[i].asString(true);
        }
        return array;
    }

    @Override
    public List<ClickHouseColumn> readColumns() throws IOException {
        if (this.input == null) {
            return Collections.emptyList();
        }
        ClickHouseFormat format = this.config.getFormat();
        if (!format.hasHeader()) {
            return DEFAULT_COLUMNS;
        }
        switch (this.config.getFormat()) {
            case TSVWithNames: 
            case TSVWithNamesAndTypes: 
            case TabSeparatedWithNames: 
            case TabSeparatedWithNamesAndTypes: {
                this.colDelimitter = (byte)9;
                break;
            }
            default: {
                this.colDelimitter = 0;
            }
        }
        this.splitter = new StreamSplitter(this.input, 10, this.config.getMaxBufferSize());
        ByteFragment headerFragment = this.splitter.next();
        if (headerFragment == null) {
            throw new IllegalArgumentException("ClickHouse response without column names");
        }
        String header = headerFragment.asString(true);
        if (header.startsWith("Code: ") && !header.contains("\t")) {
            this.input.close();
            throw new IllegalArgumentException("ClickHouse error: " + header);
        }
        String[] cols = ClickHouseTabSeparatedProcessor.toStringArray(headerFragment, this.colDelimitter);
        String[] types = null;
        if (ClickHouseFormat.TSVWithNamesAndTypes == format || ClickHouseFormat.TabSeparatedWithNamesAndTypes == format) {
            ByteFragment typesFragment = this.splitter.next();
            if (typesFragment == null) {
                throw new IllegalArgumentException("ClickHouse response without column types");
            }
            types = ClickHouseTabSeparatedProcessor.toStringArray(typesFragment, this.colDelimitter);
        }
        ArrayList<ClickHouseColumn> list = new ArrayList<ClickHouseColumn>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            list.add(ClickHouseColumn.of(cols[i], types == null ? "Nullable(String)" : types[i]));
        }
        return list;
    }

    public ClickHouseTabSeparatedProcessor(ClickHouseConfig config, ClickHouseInputStream input, OutputStream output, List<ClickHouseColumn> columns, Map<String, Object> settings) throws IOException {
        super(config, input, output, columns, settings);
        if (this.splitter == null && input != null) {
            this.splitter = new StreamSplitter(input, 10, config.getMaxBufferSize());
        }
    }

    @Override
    public Iterable<ClickHouseRecord> records() {
        return new Iterable<ClickHouseRecord>(){

            @Override
            public Iterator<ClickHouseRecord> iterator() {
                return new Records();
            }
        };
    }

    private class Records
    implements Iterator<ClickHouseRecord> {
        private ByteFragment currentRow;

        Records() {
            if (!ClickHouseTabSeparatedProcessor.this.columns.isEmpty()) {
                this.readNextRow();
            }
        }

        void readNextRow() {
            try {
                this.currentRow = ClickHouseTabSeparatedProcessor.this.splitter.next();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRow != null;
        }

        @Override
        public ClickHouseRecord next() {
            ByteFragment[] byteFragmentArray;
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more record");
            }
            if (ClickHouseTabSeparatedProcessor.this.colDelimitter != 0) {
                byteFragmentArray = this.currentRow.split(ClickHouseTabSeparatedProcessor.this.colDelimitter);
            } else {
                ByteFragment[] byteFragmentArray2 = new ByteFragment[1];
                byteFragmentArray = byteFragmentArray2;
                byteFragmentArray2[0] = this.currentRow;
            }
            final ByteFragment[] currentCols = byteFragmentArray;
            this.readNextRow();
            return new ClickHouseRecord(){

                @Override
                public int size() {
                    return currentCols.length;
                }

                @Override
                public ClickHouseValue getValue(int index) {
                    return ClickHouseStringValue.of(null, currentCols[index].asString(true));
                }

                @Override
                public ClickHouseValue getValue(String name) {
                    int index = 0;
                    for (ClickHouseColumn c : ClickHouseTabSeparatedProcessor.this.columns) {
                        if (c.getColumnName().equalsIgnoreCase(name)) {
                            return this.getValue(index);
                        }
                        ++index;
                    }
                    throw new IllegalArgumentException(ClickHouseUtils.format("Unable to find column [%s]", name));
                }
            };
        }
    }
}

