/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.core.kit;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.HmacAlgorithm;
import com.ijpay.core.XmlHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class PayKit {
    public static String hmacSha256(String data, String key) {
        return SecureUtil.hmac((HmacAlgorithm)HmacAlgorithm.HmacSHA256, (String)key).digestHex(data, "UTF-8");
    }

    public static String md5(String data) {
        return SecureUtil.md5((String)data);
    }

    public static String decryptData(String base64Data, String key) {
        return SecureUtil.aes((byte[])PayKit.md5(key).toLowerCase().getBytes()).decryptStr(base64Data);
    }

    public static String encryptData(String data, String key) {
        return SecureUtil.aes((byte[])PayKit.md5(key).toLowerCase().getBytes()).encryptBase64(data.getBytes());
    }

    public static String generateStr() {
        return IdUtil.fastSimpleUUID();
    }

    public static String createLinkString(Map<String, String> params) {
        return PayKit.createLinkString(params, false);
    }

    public static String createLinkString(Map<String, String> params, boolean encode) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuffer content = new StringBuffer();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                content.append(key + "=" + (encode ? PayKit.urlEncode(value) : value));
                continue;
            }
            content.append(key + "=" + (encode ? PayKit.urlEncode(value) : value) + "&");
        }
        return content.toString();
    }

    public static String urlEncode(String src) {
        try {
            return URLEncoder.encode(src, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StringBuilder forEachMap(Map<String, String> params, String prefix, String suffix) {
        StringBuilder xml = new StringBuilder();
        if (StrUtil.isNotEmpty((CharSequence)prefix)) {
            xml.append(prefix);
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StrUtil.isEmpty((CharSequence)value)) continue;
            xml.append("<").append(key).append(">");
            xml.append(entry.getValue());
            xml.append("</").append(key).append(">");
        }
        if (StrUtil.isNotEmpty((CharSequence)suffix)) {
            xml.append(suffix);
        }
        return xml;
    }

    public static String toXml(Map<String, String> params) {
        StringBuilder xml = PayKit.forEachMap(params, "<xml>", "</xml>");
        return xml.toString();
    }

    public static Map<String, String> xmlToMap(String xmlStr) {
        XmlHelper xmlHelper = XmlHelper.of(xmlStr);
        return xmlHelper.toMap();
    }
}

