/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.MySQLIndexHint;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.SQLServerHints;
import net.sf.jsqlparser.expression.WindowDefinition;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.Fetch;
import net.sf.jsqlparser.statement.select.First;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.LateralView;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.OptimizeFor;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.Pivot;
import net.sf.jsqlparser.statement.select.PivotVisitor;
import net.sf.jsqlparser.statement.select.PivotXml;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.Skip;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.TableStatement;
import net.sf.jsqlparser.statement.select.Top;
import net.sf.jsqlparser.statement.select.UnPivot;
import net.sf.jsqlparser.statement.select.Values;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.GroupByDeParser;
import net.sf.jsqlparser.util.deparser.LimitDeparser;
import net.sf.jsqlparser.util.deparser.OrderByDeParser;
import net.sf.jsqlparser.util.deparser.TableStatementDeParser;
import net.sf.jsqlparser.util.deparser.ValuesStatementDeParser;

public class SelectDeParser
extends AbstractDeParser<PlainSelect>
implements SelectVisitor<StringBuilder>,
SelectItemVisitor<StringBuilder>,
FromItemVisitor<StringBuilder>,
PivotVisitor<StringBuilder> {
    private ExpressionVisitor<StringBuilder> expressionVisitor;

    public SelectDeParser() {
        this(new StringBuilder());
    }

    public SelectDeParser(StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = new ExpressionDeParser(this, buffer);
    }

    public SelectDeParser(Class<? extends ExpressionDeParser> expressionDeparserClass, StringBuilder builder) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        super(builder);
        this.expressionVisitor = expressionDeparserClass.getConstructor(SelectDeParser.class, StringBuilder.class).newInstance(this, builder);
    }

    public SelectDeParser(Class<? extends ExpressionDeParser> expressionDeparserClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this(expressionDeparserClass, new StringBuilder());
    }

    public SelectDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public <S> StringBuilder visit(ParenthesedSelect select, S context) {
        UnPivot unpivot;
        Pivot pivot;
        Alias alias;
        List<WithItem> withItemsList = select.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.buffer.append("WITH ");
            for (WithItem withItem : withItemsList) {
                withItem.accept(this, context);
                this.buffer.append(" ");
            }
        }
        this.buffer.append("(");
        select.getSelect().accept(this, context);
        this.buffer.append(")");
        if (select.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(select.isOracleSiblings(), select.getOrderByElements());
        }
        if ((alias = select.getAlias()) != null) {
            this.buffer.append(alias);
        }
        if ((pivot = select.getPivot()) != null) {
            pivot.accept(this, context);
        }
        if ((unpivot = select.getUnPivot()) != null) {
            unpivot.accept(this, context);
        }
        if (select.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(select.getLimit());
        }
        if (select.getOffset() != null) {
            this.visit(select.getOffset());
        }
        if (select.getFetch() != null) {
            this.visit(select.getFetch());
        }
        if (select.getIsolation() != null) {
            this.buffer.append(select.getIsolation().toString());
        }
        return this.buffer;
    }

    public void visit(Top top) {
        this.buffer.append(top).append(" ");
    }

    @Override
    public <S> StringBuilder visit(PlainSelect plainSelect, S context) {
        Top top;
        First first;
        Skip skip;
        OracleHint hint;
        List<WithItem> withItemsList = plainSelect.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = withItemsList.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this, context);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("SELECT ");
        if (plainSelect.getMySqlHintStraightJoin()) {
            this.buffer.append("STRAIGHT_JOIN ");
        }
        if ((hint = plainSelect.getOracleHint()) != null) {
            this.buffer.append(hint).append(" ");
        }
        if ((skip = plainSelect.getSkip()) != null) {
            this.buffer.append(skip).append(" ");
        }
        if ((first = plainSelect.getFirst()) != null) {
            this.buffer.append(first).append(" ");
        }
        this.deparseDistinctClause(plainSelect.getDistinct());
        if (plainSelect.getBigQuerySelectQualifier() != null) {
            switch (plainSelect.getBigQuerySelectQualifier()) {
                case AS_STRUCT: {
                    this.buffer.append("AS STRUCT ");
                    break;
                }
                case AS_VALUE: {
                    this.buffer.append("AS VALUE ");
                }
            }
        }
        if ((top = plainSelect.getTop()) != null) {
            this.visit(top);
        }
        if (plainSelect.getMySqlSqlCacheFlag() != null) {
            this.buffer.append(plainSelect.getMySqlSqlCacheFlag().name()).append(" ");
        }
        if (plainSelect.getMySqlSqlCalcFoundRows()) {
            this.buffer.append("SQL_CALC_FOUND_ROWS").append(" ");
        }
        this.deparseSelectItemsClause(plainSelect.getSelectItems());
        if (plainSelect.getIntoTables() != null) {
            this.buffer.append(" INTO ");
            Iterator<Table> iter = plainSelect.getIntoTables().iterator();
            while (iter.hasNext()) {
                this.visit(iter.next(), (Object)context);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getFromItem() != null) {
            Table table;
            this.buffer.append(" FROM ");
            if (plainSelect.isUsingOnly()) {
                this.buffer.append("ONLY ");
            }
            plainSelect.getFromItem().accept(this, context);
            if (plainSelect.getFromItem() instanceof Table && (table = (Table)plainSelect.getFromItem()).getSampleClause() != null) {
                table.getSampleClause().appendTo(this.buffer);
            }
        }
        if (plainSelect.getLateralViews() != null) {
            for (LateralView lateralView : plainSelect.getLateralViews()) {
                this.deparseLateralView(lateralView);
            }
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                this.deparseJoin(join);
            }
        }
        if (plainSelect.isUsingFinal()) {
            this.buffer.append(" FINAL");
        }
        if (plainSelect.getKsqlWindow() != null) {
            this.buffer.append(" WINDOW ");
            this.buffer.append(plainSelect.getKsqlWindow().toString());
        }
        this.deparseWhereClause(plainSelect);
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept(this.expressionVisitor, context);
        }
        if (plainSelect.getGroupBy() != null) {
            this.buffer.append(" ");
            new GroupByDeParser(this.expressionVisitor, this.buffer).deParse(plainSelect.getGroupBy());
        }
        if (plainSelect.getHaving() != null) {
            this.buffer.append(" HAVING ");
            plainSelect.getHaving().accept(this.expressionVisitor, context);
        }
        if (plainSelect.getQualify() != null) {
            this.buffer.append(" QUALIFY ");
            plainSelect.getQualify().accept(this.expressionVisitor, context);
        }
        if (plainSelect.getWindowDefinitions() != null) {
            this.buffer.append(" WINDOW ");
            this.buffer.append(plainSelect.getWindowDefinitions().stream().map(WindowDefinition::toString).collect(Collectors.joining(", ")));
        }
        if (plainSelect.getForClause() != null) {
            plainSelect.getForClause().appendTo(this.buffer);
        }
        this.deparseOrderByElementsClause(plainSelect, plainSelect.getOrderByElements());
        if (plainSelect.isEmitChanges()) {
            this.buffer.append(" EMIT CHANGES");
        }
        if (plainSelect.getLimitBy() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(plainSelect.getLimitBy());
        }
        if (plainSelect.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.visit(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.visit(plainSelect.getFetch());
        }
        if (plainSelect.getIsolation() != null) {
            this.buffer.append(plainSelect.getIsolation().toString());
        }
        if (plainSelect.getForMode() != null) {
            this.buffer.append(" FOR ");
            this.buffer.append(plainSelect.getForMode().getValue());
            if (plainSelect.getForUpdateTable() != null) {
                this.buffer.append(" OF ").append(plainSelect.getForUpdateTable());
            }
            if (plainSelect.getWait() != null) {
                this.buffer.append(plainSelect.getWait());
            }
            if (plainSelect.isNoWait()) {
                this.buffer.append(" NOWAIT");
            } else if (plainSelect.isSkipLocked()) {
                this.buffer.append(" SKIP LOCKED");
            }
        }
        if (plainSelect.getOptimizeFor() != null) {
            this.deparseOptimizeFor(plainSelect.getOptimizeFor());
        }
        if (plainSelect.getForXmlPath() != null) {
            this.buffer.append(" FOR XML PATH(").append(plainSelect.getForXmlPath()).append(")");
        }
        if (plainSelect.getIntoTempTable() != null) {
            this.buffer.append(" INTO TEMP ").append(plainSelect.getIntoTempTable());
        }
        if (plainSelect.isUseWithNoLog()) {
            this.buffer.append(" WITH NO LOG");
        }
        return this.buffer;
    }

    protected void deparseWhereClause(PlainSelect plainSelect) {
        if (plainSelect.getWhere() != null) {
            this.buffer.append(" WHERE ");
            plainSelect.getWhere().accept(this.expressionVisitor, null);
        }
    }

    protected void deparseDistinctClause(Distinct distinct) {
        if (distinct != null) {
            if (distinct.isUseUnique()) {
                this.buffer.append("UNIQUE ");
            } else {
                this.buffer.append("DISTINCT ");
            }
            if (distinct.getOnSelectItems() != null) {
                this.buffer.append("ON (");
                Iterator<SelectItem<?>> iter = distinct.getOnSelectItems().iterator();
                while (iter.hasNext()) {
                    SelectItem<?> selectItem = iter.next();
                    selectItem.accept(this, null);
                    if (!iter.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            }
        }
    }

    protected void deparseSelectItemsClause(List<SelectItem<?>> selectItems) {
        if (selectItems != null) {
            Iterator<SelectItem<?>> iter = selectItems.iterator();
            while (iter.hasNext()) {
                SelectItem<?> selectItem = iter.next();
                selectItem.accept(this, null);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
    }

    protected void deparseOrderByElementsClause(PlainSelect plainSelect, List<OrderByElement> orderByElements) {
        if (orderByElements != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(plainSelect.isOracleSiblings(), orderByElements);
        }
    }

    @Override
    public <S> StringBuilder visit(SelectItem<?> selectItem, S context) {
        selectItem.getExpression().accept(this.expressionVisitor, context);
        if (selectItem.getAlias() != null) {
            this.buffer.append(selectItem.getAlias().toString());
        }
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Table tableName, S context) {
        SQLServerHints sqlServerHints;
        MySQLIndexHint indexHint;
        UnPivot unpivot;
        Pivot pivot;
        this.buffer.append(tableName.getFullyQualifiedName());
        Alias alias = tableName.getAlias();
        if (alias != null) {
            this.buffer.append(alias);
        }
        if ((pivot = tableName.getPivot()) != null) {
            pivot.accept(this, context);
        }
        if ((unpivot = tableName.getUnPivot()) != null) {
            unpivot.accept(this, context);
        }
        if ((indexHint = tableName.getIndexHint()) != null) {
            this.buffer.append(indexHint);
        }
        if ((sqlServerHints = tableName.getSqlServerHints()) != null) {
            this.buffer.append(sqlServerHints);
        }
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Pivot pivot, S context) {
        this.buffer.append(" PIVOT (").append(PlainSelect.getStringList(pivot.getFunctionItems()));
        this.buffer.append(" FOR ");
        pivot.getForColumns().accept(this.expressionVisitor, context);
        this.buffer.append(" IN ").append(PlainSelect.getStringList(pivot.getInItems(), true, true));
        this.buffer.append(")");
        if (pivot.getAlias() != null) {
            this.buffer.append(pivot.getAlias().toString());
        }
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(UnPivot unpivot, S context) {
        boolean showOptions = unpivot.getIncludeNullsSpecified();
        boolean includeNulls = unpivot.getIncludeNulls();
        List<Column> unPivotClause = unpivot.getUnPivotClause();
        List<Column> unpivotForClause = unpivot.getUnPivotForClause();
        this.buffer.append(" UNPIVOT").append(showOptions && includeNulls ? " INCLUDE NULLS" : "").append(showOptions && !includeNulls ? " EXCLUDE NULLS" : "").append(" (").append(PlainSelect.getStringList(unPivotClause, true, unPivotClause != null && unPivotClause.size() > 1)).append(" FOR ").append(PlainSelect.getStringList(unpivotForClause, true, unpivotForClause != null && unpivotForClause.size() > 1)).append(" IN ").append(PlainSelect.getStringList(unpivot.getUnPivotInClause(), true, true)).append(")");
        if (unpivot.getAlias() != null) {
            this.buffer.append(unpivot.getAlias().toString());
        }
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(PivotXml pivot, S context) {
        ExpressionList<Column> forColumns = pivot.getForColumns();
        this.buffer.append(" PIVOT XML (").append(PlainSelect.getStringList(pivot.getFunctionItems())).append(" FOR ").append(PlainSelect.getStringList(forColumns, true, forColumns != null && forColumns.size() > 1)).append(" IN (");
        if (pivot.isInAny()) {
            this.buffer.append("ANY");
        } else if (pivot.getInSelect() != null) {
            this.buffer.append(pivot.getInSelect());
        } else {
            this.buffer.append(PlainSelect.getStringList(pivot.getInItems()));
        }
        this.buffer.append("))");
        return this.buffer;
    }

    public void visit(Offset offset) {
        this.buffer.append(" OFFSET ");
        offset.getOffset().accept(this.expressionVisitor, null);
        if (offset.getOffsetParam() != null) {
            this.buffer.append(" ").append(offset.getOffsetParam());
        }
    }

    public void visit(Fetch fetch) {
        this.buffer.append(" FETCH ");
        if (fetch.isFetchParamFirst()) {
            this.buffer.append("FIRST ");
        } else {
            this.buffer.append("NEXT ");
        }
        if (fetch.getExpression() != null) {
            fetch.getExpression().accept(this.expressionVisitor, null);
        }
        for (String p : fetch.getFetchParameters()) {
            this.buffer.append(" ").append(p);
        }
    }

    public ExpressionVisitor<StringBuilder> getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor<StringBuilder> visitor) {
        this.expressionVisitor = visitor;
    }

    public void deparseJoin(Join join) {
        if (join.isGlobal()) {
            this.buffer.append(" GLOBAL ");
        }
        if (join.isSimple() && join.isOuter()) {
            this.buffer.append(", OUTER ");
        } else if (join.isSimple()) {
            this.buffer.append(", ");
        } else {
            if (join.isNatural()) {
                this.buffer.append(" NATURAL");
            }
            if (join.isRight()) {
                this.buffer.append(" RIGHT");
            } else if (join.isFull()) {
                this.buffer.append(" FULL");
            } else if (join.isLeft()) {
                this.buffer.append(" LEFT");
            } else if (join.isCross()) {
                this.buffer.append(" CROSS");
            }
            if (join.isOuter()) {
                this.buffer.append(" OUTER");
            } else if (join.isInner()) {
                this.buffer.append(" INNER");
            } else if (join.isSemi()) {
                this.buffer.append(" SEMI");
            }
            if (join.isStraight()) {
                this.buffer.append(" STRAIGHT_JOIN ");
            } else if (join.isApply()) {
                this.buffer.append(" APPLY ");
            } else {
                if (join.getJoinHint() != null) {
                    this.buffer.append(" ").append(join.getJoinHint());
                }
                this.buffer.append(" JOIN ");
            }
        }
        FromItem fromItem = join.getFromItem();
        fromItem.accept(this, null);
        if (join.isWindowJoin()) {
            this.buffer.append(" WITHIN ");
            this.buffer.append(join.getJoinWindow().toString());
        }
        for (Expression onExpression : join.getOnExpressions()) {
            this.buffer.append(" ON ");
            onExpression.accept(this.expressionVisitor, null);
        }
        if (!join.getUsingColumns().isEmpty()) {
            this.buffer.append(" USING (");
            Iterator<Column> iterator = join.getUsingColumns().iterator();
            while (iterator.hasNext()) {
                Column column = iterator.next();
                this.buffer.append(column.toString());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
    }

    public void deparseLateralView(LateralView lateralView) {
        this.buffer.append(" LATERAL VIEW");
        if (lateralView.isUsingOuter()) {
            this.buffer.append(" OUTER");
        }
        this.buffer.append(" ");
        lateralView.getGeneratorFunction().accept(this.expressionVisitor, null);
        if (lateralView.getTableAlias() != null) {
            this.buffer.append(" ").append(lateralView.getTableAlias());
        }
        this.buffer.append(" ").append(lateralView.getColumnAlias());
    }

    @Override
    public <S> StringBuilder visit(SetOperationList list, S context) {
        List<WithItem> withItemsList = list.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = withItemsList.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this, context);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        for (int i = 0; i < list.getSelects().size(); ++i) {
            if (i != 0) {
                this.buffer.append(' ').append(list.getOperations().get(i - 1)).append(' ');
            }
            list.getSelects().get(i).accept(this, context);
        }
        if (list.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(list.getOrderByElements());
        }
        if (list.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(list.getLimit());
        }
        if (list.getOffset() != null) {
            this.visit(list.getOffset());
        }
        if (list.getFetch() != null) {
            this.visit(list.getFetch());
        }
        if (list.getIsolation() != null) {
            this.buffer.append(list.getIsolation().toString());
        }
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(WithItem withItem, S context) {
        if (withItem.isRecursive()) {
            this.buffer.append("RECURSIVE ");
        }
        this.buffer.append(withItem.getAlias().getName());
        if (withItem.getWithItemList() != null) {
            this.buffer.append(" ").append(PlainSelect.getStringList(withItem.getWithItemList(), true, true));
        }
        this.buffer.append(" AS ");
        withItem.getSelect().accept(this, context);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(LateralSubSelect lateralSubSelect, S context) {
        this.buffer.append(lateralSubSelect.getPrefix());
        this.visit((ParenthesedSelect)lateralSubSelect, (Object)context);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(TableStatement tableStatement, S context) {
        new TableStatementDeParser(this.expressionVisitor, this.buffer).deParse(tableStatement);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(TableFunction tableFunction, S context) {
        this.buffer.append(tableFunction.toString());
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(ParenthesedFromItem fromItem, S context) {
        this.buffer.append("(");
        fromItem.getFromItem().accept(this, context);
        List<Join> joins = fromItem.getJoins();
        if (joins != null) {
            for (Join join : joins) {
                if (join.isSimple()) {
                    this.buffer.append(", ").append(join);
                    continue;
                }
                this.buffer.append(" ").append(join);
            }
        }
        this.buffer.append(")");
        if (fromItem.getAlias() != null) {
            this.buffer.append(fromItem.getAlias().toString());
        }
        if (fromItem.getPivot() != null) {
            this.visit(fromItem.getPivot(), (Object)context);
        }
        if (fromItem.getUnPivot() != null) {
            this.visit(fromItem.getUnPivot(), (Object)context);
        }
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Values values, S context) {
        new ValuesStatementDeParser(this.expressionVisitor, this.buffer).deParse(values);
        return this.buffer;
    }

    @Override
    public void visit(Values values) {
        SelectVisitor.super.visit(values);
    }

    @Override
    public void visit(ParenthesedSelect select) {
        this.visit(select, (Object)null);
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        this.visit(plainSelect, (Object)null);
    }

    @Override
    public void visit(SelectItem<?> selectExpressionItem) {
        this.visit((SelectItem)selectExpressionItem, (Object)null);
    }

    @Override
    public void visit(Table tableName) {
        this.visit(tableName, (Object)null);
    }

    @Override
    public void visit(Pivot pivot) {
        this.visit(pivot, (Object)null);
    }

    @Override
    public void visit(UnPivot unpivot) {
        this.visit(unpivot, (Object)null);
    }

    @Override
    public void visit(PivotXml pivot) {
        this.visit(pivot, (Object)null);
    }

    @Override
    public void visit(SetOperationList list) {
        this.visit(list, (Object)null);
    }

    @Override
    public void visit(WithItem withItem) {
        this.visit(withItem, (Object)null);
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        this.visit(lateralSubSelect, (Object)null);
    }

    @Override
    public void visit(TableStatement tableStatement) {
        this.visit(tableStatement, (Object)null);
    }

    @Override
    public void visit(TableFunction tableFunction) {
        this.visit(tableFunction, (Object)null);
    }

    @Override
    public void visit(ParenthesedFromItem fromItem) {
        this.visit(fromItem, (Object)null);
    }

    private void deparseOptimizeFor(OptimizeFor optimizeFor) {
        this.buffer.append(" OPTIMIZE FOR ");
        this.buffer.append(optimizeFor.getRowCount());
        this.buffer.append(" ROWS");
    }

    @Override
    void deParse(PlainSelect statement) {
        statement.accept(this, null);
    }
}

