/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.OrderByVisitor;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.LimitDeparser;
import net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class UpdateDeParser
extends AbstractDeParser<Update>
implements OrderByVisitor<StringBuilder> {
    private ExpressionVisitor<StringBuilder> expressionVisitor = new ExpressionVisitorAdapter<StringBuilder>();

    public UpdateDeParser() {
        super(new StringBuilder());
    }

    public UpdateDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(Update update) {
        if (update.getWithItemsList() != null && !update.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = update.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                this.buffer.append(withItem);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("UPDATE ");
        if (update.getOracleHint() != null) {
            this.buffer.append(update.getOracleHint()).append(" ");
        }
        if (update.getModifierPriority() != null) {
            this.buffer.append((Object)update.getModifierPriority()).append(" ");
        }
        if (update.isModifierIgnore()) {
            this.buffer.append("IGNORE ");
        }
        this.buffer.append(update.getTable());
        if (update.getStartJoins() != null) {
            for (Join join : update.getStartJoins()) {
                if (join.isSimple()) {
                    this.buffer.append(", ").append(join);
                    continue;
                }
                this.buffer.append(" ").append(join);
            }
        }
        this.buffer.append(" SET ");
        this.deparseUpdateSetsClause(update);
        if (update.getOutputClause() != null) {
            update.getOutputClause().appendTo(this.buffer);
        }
        if (update.getFromItem() != null) {
            this.buffer.append(" FROM ").append(update.getFromItem());
            if (update.getJoins() != null) {
                for (Join join : update.getJoins()) {
                    if (join.isSimple()) {
                        this.buffer.append(", ").append(join);
                        continue;
                    }
                    this.buffer.append(" ").append(join);
                }
            }
        }
        this.deparseWhereClause(update);
        if (update.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(update.getOrderByElements());
        }
        if (update.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(update.getLimit());
        }
        if (update.getReturningClause() != null) {
            update.getReturningClause().appendTo(this.buffer);
        }
    }

    protected void deparseWhereClause(Update update) {
        if (update.getWhere() != null) {
            this.buffer.append(" WHERE ");
            update.getWhere().accept(this.expressionVisitor, null);
        }
    }

    protected void deparseUpdateSetsClause(Update update) {
        UpdateDeParser.deparseUpdateSets(update.getUpdateSets(), this.buffer, this.expressionVisitor);
    }

    public ExpressionVisitor<StringBuilder> getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor<StringBuilder> visitor) {
        this.expressionVisitor = visitor;
    }

    @Override
    public <S> StringBuilder visit(OrderByElement orderBy, S context) {
        orderBy.getExpression().accept(this.expressionVisitor, context);
        if (!orderBy.isAsc()) {
            this.buffer.append(" DESC");
        } else if (orderBy.isAscDescPresent()) {
            this.buffer.append(" ASC");
        }
        if (orderBy.getNullOrdering() != null) {
            this.buffer.append(' ');
            this.buffer.append(orderBy.getNullOrdering() == OrderByElement.NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
        }
        return this.buffer;
    }
}

