/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.runtime.function.internal.UnpackingArgsFunction;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.Sequence;
import com.googlecode.aviator.runtime.type.seq.ArraySequence;
import com.googlecode.aviator.runtime.type.seq.CharSeqSequence;
import com.googlecode.aviator.runtime.type.seq.EmptySequence;
import com.googlecode.aviator.runtime.type.seq.IterableSequence;
import com.googlecode.aviator.runtime.type.seq.LimitedSequence;
import com.googlecode.aviator.runtime.type.seq.MapSequence;
import com.googlecode.aviator.utils.Env;
import java.io.IOException;
import java.math.MathContext;
import java.util.Map;

public final class RuntimeUtils {
    private RuntimeUtils() {
    }

    public static final AviatorEvaluatorInstance getInstance(Map<String, Object> env) {
        if (env instanceof Env) {
            return ((Env)env).getInstance();
        }
        return AviatorEvaluator.getInstance();
    }

    public static final AviatorFunction unpackArgsFunction(AviatorFunction fn) {
        if (fn instanceof UnpackingArgsFunction) {
            return fn;
        }
        return new UnpackingArgsFunction(fn);
    }

    public static Sequence seq(Object o, Map<String, Object> env) {
        int maxLoopCount;
        Sequence seq = null;
        if (o == null) {
            return EmptySequence.INSTANCE;
        }
        if (o instanceof Sequence) {
            seq = (Sequence)o;
        } else if (o instanceof CharSequence) {
            seq = new CharSeqSequence((CharSequence)o);
        } else if (o instanceof Iterable) {
            seq = new IterableSequence((Iterable)o);
        } else if (o.getClass().isArray()) {
            seq = new ArraySequence(o);
        } else if (o instanceof Map) {
            seq = new MapSequence((Map)o);
        } else {
            throw new IllegalArgumentException(o + " is not a sequence");
        }
        if (env instanceof Env && (maxLoopCount = RuntimeUtils.getInstance(env).getOptionValue((Options)Options.MAX_LOOP_COUNT).number) > 0) {
            return new LimitedSequence(seq, maxLoopCount);
        }
        return seq;
    }

    public static final AviatorObject assertNotNull(AviatorObject object) {
        if (object != null) {
            return object;
        }
        return AviatorNil.NIL;
    }

    public static final MathContext getMathContext(Map<String, Object> env) {
        return RuntimeUtils.getInstance(env).getOptionValue((Options)Options.MATH_CONTEXT).mathContext;
    }

    public static final void printlnTrace(Map<String, Object> env, String msg) {
        try {
            RuntimeUtils.getInstance(env).getTraceOutputStream().write(("[Aviator TRACE] " + msg + "\n").getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final boolean isTracedEval(Map<String, Object> env) {
        return RuntimeUtils.getInstance(env).getOptionValue((Options)Options.TRACE_EVAL).bool;
    }

    public static AviatorFunction getFunction(Object object, Map<String, Object> env) {
        Object value;
        if (object instanceof AviatorFunction) {
            return (AviatorFunction)object;
        }
        if (object instanceof AviatorObject && (value = ((AviatorObject)object).getValue(env)) instanceof AviatorFunction) {
            return (AviatorFunction)value;
        }
        throw new ClassCastException("Could not cast object " + object + " into a aviator function.");
    }

    public static AviatorFunction getFunction(Map<String, Object> env, String name) {
        return RuntimeUtils.getInstance(env).getFunction(name);
    }

    public static void printStackTrace(Map<String, Object> env, Exception e) {
        if (RuntimeUtils.isTracedEval(env)) {
            e.printStackTrace();
        }
    }
}

