/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.internal;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.internal.CatchHandler;
import com.googlecode.aviator.runtime.function.internal.ReducerResult;
import com.googlecode.aviator.runtime.function.internal.ReducerState;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.utils.Constants;
import com.googlecode.aviator.utils.Reflector;
import java.util.List;
import java.util.Map;

public class TryCatchFunction
extends AbstractFunction {
    private static final long serialVersionUID = 7314510329619948965L;
    public static final TryCatchFunction INSTANCE = new TryCatchFunction();

    private TryCatchFunction() {
    }

    @Override
    public String getName() {
        return "__try";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2, AviatorObject arg3, AviatorObject arg4) {
        AviatorFunction tryBody = (AviatorFunction)((Object)arg1);
        List catchHandlers = (List)arg2.getValue(env);
        AviatorFunction finallyBody = arg3 != AviatorNil.NIL ? (AviatorFunction)((Object)arg3) : null;
        AviatorObject result = null;
        try {
            result = tryBody.call(env);
        }
        catch (Throwable t) {
            boolean handle = false;
            if (catchHandlers != null) {
                for (CatchHandler handler : catchHandlers) {
                    if (!handler.isMatch(t.getClass())) continue;
                    AviatorObject ret = handler.getFunc().call(env, AviatorRuntimeJavaType.valueOf(t));
                    result = this.chooseResult(result, ret);
                    handle = true;
                    break;
                }
            }
            if (!handle) {
                throw Reflector.sneakyThrow(t);
            }
        }
        finally {
            if (finallyBody != null) {
                AviatorObject ret = finallyBody.call(env);
                result = this.chooseResult(result, ret);
            }
        }
        if (this.isReturnResult(result)) {
            return result;
        }
        Object val = arg4.getValue(env);
        if (val == Constants.REDUCER_EMPTY) {
            return result;
        }
        AviatorFunction continueFn = (AviatorFunction)val;
        AviatorObject contResult = continueFn.call(env);
        if (contResult == Constants.REDUCER_EMPTY) {
            return result;
        }
        return contResult;
    }

    public AviatorObject chooseResult(AviatorObject result, AviatorObject ret) {
        if (result instanceof ReducerResult) {
            if (ret instanceof ReducerResult && this.isNewState(result, ret)) {
                return ret;
            }
            return result;
        }
        return ret;
    }

    private boolean isNewState(AviatorObject result, AviatorObject ret) {
        return ((ReducerResult)ret).state.compareTo(((ReducerResult)result).state) >= 0;
    }

    private boolean isReturnResult(AviatorObject ret) {
        return ret instanceof ReducerResult && ((ReducerResult)ret).state == ReducerState.Return;
    }
}

