/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.bytecode.structure;

import com.jfirer.baseutil.bytecode.structure.Attribute.AttributeInfo;
import com.jfirer.baseutil.bytecode.structure.constantinfo.ConstantInfo;
import com.jfirer.baseutil.bytecode.structure.constantinfo.Utf8Info;
import com.jfirer.baseutil.bytecode.util.BinaryData;
import java.util.Arrays;

public class FieldInfo {
    private int access_flags;
    private int name_index;
    private String name;
    private String descriptor;
    private AttributeInfo[] attributeInfos;

    public void resolve(BinaryData binaryData, ConstantInfo[] constantInfos) {
        this.access_flags = binaryData.readShort();
        this.name_index = binaryData.readShort();
        this.name = ((Utf8Info)constantInfos[this.name_index - 1]).getValue();
        int descriptor_index = binaryData.readShort();
        this.descriptor = ((Utf8Info)constantInfos[descriptor_index - 1]).getValue();
        int attributes_count = binaryData.readShort();
        this.attributeInfos = new AttributeInfo[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            this.attributeInfos[i] = AttributeInfo.parse(binaryData, constantInfos);
        }
    }

    public String getName() {
        return this.name;
    }

    public AttributeInfo[] getAttributeInfos() {
        return this.attributeInfos;
    }

    public String toString() {
        return "FieldInfo{name='" + this.name + '\'' + ", descriptor='" + this.descriptor + '\'' + ", attributeInfos=" + Arrays.toString(this.attributeInfos) + '}';
    }
}

