/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.bytecode.util;

public class BinaryData {
    private byte[] value;
    private int index;

    public BinaryData(byte[] value) {
        this.value = value;
        this.index = 0;
    }

    public byte readByte() {
        byte b = this.value[this.index];
        ++this.index;
        return b;
    }

    public void addIndex(int add) {
        this.index += add;
    }

    public int readShort() {
        int result = (0xFF & this.value[this.index]) << 8 | 0xFF & this.value[this.index + 1];
        this.index += 2;
        return result;
    }

    public int readInt() {
        int result = (this.value[this.index] & 0xFF) << 24 | (this.value[this.index + 1] & 0xFF) << 16 | (this.value[this.index + 2] & 0xFF) << 8 | (this.value[this.index + 3] & 0xFF) << 0;
        this.index += 4;
        return result;
    }

    public long readLong() {
        long result = ((long)this.value[this.index] & 0xFFL) << 56 | ((long)this.value[this.index + 1] & 0xFFL) << 48 | ((long)this.value[this.index + 2] & 0xFFL) << 40 | ((long)this.value[this.index + 3] & 0xFFL) << 32 | ((long)this.value[this.index + 4] & 0xFFL) << 24 | ((long)this.value[this.index + 5] & 0xFFL) << 16 | ((long)this.value[this.index + 6] & 0xFFL) << 8 | (long)this.value[this.index + 7] & 0xFFL;
        this.index += 8;
        return result;
    }

    public void read(byte[] dest) {
        System.arraycopy(this.value, this.index, dest, 0, dest.length);
        this.index += dest.length;
    }
}

