/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.concurrent;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public class SerialLock<T> {
    private static final Unsafe unsafe;
    private static final long NEXT_OFF;
    private static final SerialNode TerminationNode;
    private ConcurrentMap<T, SerialNode> store = new ConcurrentHashMap<T, SerialNode>();

    public void exec(T key, Runnable task) {
        SerialNode ns = new SerialNode(task);
        SerialNode cs = this.store.putIfAbsent(key, ns);
        if (cs == null) {
            cs = ns;
            this.processCs(cs, key);
        } else {
            boolean exec = false;
            while (true) {
                SerialNode next;
                if ((next = cs.next) == null) {
                    if (!cs.casNext(ns)) continue;
                    while (!ns.current) {
                        LockSupport.park();
                    }
                    exec = true;
                    break;
                }
                if (next == TerminationNode) {
                    if (!this.store.replace(key, cs, ns)) break;
                    exec = true;
                    break;
                }
                cs = next;
            }
            if (exec) {
                this.processCs(ns, key);
            } else {
                this.exec(key, task);
            }
        }
    }

    void processCs(SerialNode cs, T key) {
        cs.current = true;
        try {
            cs.runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SerialNode next = cs.next;
        if (next == null) {
            if (cs.casTermination()) {
                this.store.remove(key, cs);
                return;
            }
            next = cs.next;
        }
        if (!this.store.replace(key, cs, next)) {
            throw new UnsupportedOperationException();
        }
        next.current = true;
        next.wakeup();
    }

    static {
        TerminationNode = new SerialNode(null);
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            Field nextField = SerialNode.class.getDeclaredField("next");
            NEXT_OFF = unsafe.objectFieldOffset(nextField);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static class SerialNode {
        final Runnable runnable;
        final Thread owner;
        volatile SerialNode next;
        volatile boolean current = false;

        SerialNode(Runnable runnable) {
            this.runnable = runnable;
            this.owner = Thread.currentThread();
        }

        boolean casTermination() {
            return unsafe.compareAndSwapObject(this, NEXT_OFF, null, TerminationNode);
        }

        void wakeup() {
            LockSupport.unpark(this.owner);
        }

        boolean casNext(SerialNode ns) {
            return unsafe.compareAndSwapObject(this, NEXT_OFF, null, ns);
        }
    }
}

