/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.encrypt;

public class Base64Tool {
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    public static String encode(byte[] src) {
        StringBuilder cache = new StringBuilder();
        int i = 0;
        while (i < src.length) {
            int base;
            int hign = i;
            int middle = hign + 1;
            int low = middle + 1;
            if (low < src.length) {
                base = (src[hign] & 0xFF) << 16 | (src[middle] & 0xFF) << 8 | src[low] & 0xFF;
                cache.append(alphabet[base >> 18 & 0x3F]);
                cache.append(alphabet[base >> 12 & 0x3F]);
                cache.append(alphabet[base >> 6 & 0x3F]);
                cache.append(alphabet[base & 0x3F]);
                i = low + 1;
                continue;
            }
            if (middle < src.length) {
                base = (src[hign] & 0xFF) << 8 | src[middle] & 0xFF;
                cache.append(alphabet[base >> 10 & 0x3F]);
                cache.append(alphabet[base >> 4 & 0x3F]);
                cache.append(alphabet[(base & 0xF) << 2]);
                cache.append('=');
                return cache.toString();
            }
            base = src[hign] & 0xFF;
            cache.append(alphabet[base >> 2 & 0x3F]);
            cache.append(alphabet[(base & 3) << 4]);
            cache.append('=');
            cache.append('=');
            return cache.toString();
        }
        return cache.toString();
    }

    public static byte[] decode(String ciphertext) {
        char[] charArray = null;
        if ((ciphertext.length() & 3) == 0) {
            charArray = ciphertext.toCharArray();
        } else if ((ciphertext.length() & 3) == 3) {
            charArray = new char[ciphertext.length() + 1];
            System.arraycopy(ciphertext.toCharArray(), 0, charArray, 0, ciphertext.length());
            charArray[charArray.length - 1] = 61;
        } else if ((ciphertext.length() & 3) == 2) {
            charArray = new char[ciphertext.length() + 2];
            System.arraycopy(ciphertext.toCharArray(), 0, charArray, 0, ciphertext.length());
            charArray[charArray.length - 2] = 61;
            charArray[charArray.length - 1] = 61;
        } else {
            throw new UnsupportedOperationException();
        }
        byte[] result = charArray[charArray.length - 2] == '=' ? new byte[charArray.length / 4 * 3 - 2] : (charArray[charArray.length - 1] == '=' ? new byte[charArray.length / 4 * 3 - 1] : new byte[charArray.length / 4 * 3]);
        int j = 0;
        int i = 0;
        while (i < charArray.length) {
            byte b;
            byte a;
            int h1 = i;
            int h2 = h1 + 1;
            int h3 = h2 + 1;
            int h4 = h3 + 1;
            if (charArray[h3] == '=') {
                result[j] = a = (byte)((Base64Tool.toByte(charArray[h1]) & 0x3F) << 2 | (Base64Tool.toByte(charArray[h2]) & 0x3F) >> 4);
                return result;
            }
            if (charArray[h4] == '=') {
                a = (byte)((Base64Tool.toByte(charArray[h1]) & 0xFF) << 2 | (Base64Tool.toByte(charArray[h2]) & 0x3F) >> 4);
                b = (byte)((Base64Tool.toByte(charArray[h2]) & 0xF) << 4 | (Base64Tool.toByte(charArray[h3]) & 0x3F) >> 2);
                result[j++] = a;
                result[j++] = b;
                return result;
            }
            a = (byte)((Base64Tool.toByte(charArray[h1]) & 0x3F) << 2 | (Base64Tool.toByte(charArray[h2]) & 0x3F) >> 4);
            b = (byte)((Base64Tool.toByte(charArray[h2]) & 0xF) << 4 | (Base64Tool.toByte(charArray[h3]) & 0x3F) >> 2);
            byte c = (byte)((Base64Tool.toByte(charArray[h3]) & 3) << 6 | Base64Tool.toByte(charArray[h4]) & 0x3F);
            result[j++] = a;
            result[j++] = b;
            result[j++] = c;
            i = h4 + 1;
        }
        return result;
    }

    private static byte toByte(char c) {
        switch (c) {
            case 'A': {
                return 0;
            }
            case 'B': {
                return 1;
            }
            case 'C': {
                return 2;
            }
            case 'D': {
                return 3;
            }
            case 'E': {
                return 4;
            }
            case 'F': {
                return 5;
            }
            case 'G': {
                return 6;
            }
            case 'H': {
                return 7;
            }
            case 'I': {
                return 8;
            }
            case 'J': {
                return 9;
            }
            case 'K': {
                return 10;
            }
            case 'L': {
                return 11;
            }
            case 'M': {
                return 12;
            }
            case 'N': {
                return 13;
            }
            case 'O': {
                return 14;
            }
            case 'P': {
                return 15;
            }
            case 'Q': {
                return 16;
            }
            case 'R': {
                return 17;
            }
            case 'S': {
                return 18;
            }
            case 'T': {
                return 19;
            }
            case 'U': {
                return 20;
            }
            case 'V': {
                return 21;
            }
            case 'W': {
                return 22;
            }
            case 'X': {
                return 23;
            }
            case 'Y': {
                return 24;
            }
            case 'Z': {
                return 25;
            }
            case 'a': {
                return 26;
            }
            case 'b': {
                return 27;
            }
            case 'c': {
                return 28;
            }
            case 'd': {
                return 29;
            }
            case 'e': {
                return 30;
            }
            case 'f': {
                return 31;
            }
            case 'g': {
                return 32;
            }
            case 'h': {
                return 33;
            }
            case 'i': {
                return 34;
            }
            case 'j': {
                return 35;
            }
            case 'k': {
                return 36;
            }
            case 'l': {
                return 37;
            }
            case 'm': {
                return 38;
            }
            case 'n': {
                return 39;
            }
            case 'o': {
                return 40;
            }
            case 'p': {
                return 41;
            }
            case 'q': {
                return 42;
            }
            case 'r': {
                return 43;
            }
            case 's': {
                return 44;
            }
            case 't': {
                return 45;
            }
            case 'u': {
                return 46;
            }
            case 'v': {
                return 47;
            }
            case 'w': {
                return 48;
            }
            case 'x': {
                return 49;
            }
            case 'y': {
                return 50;
            }
            case 'z': {
                return 51;
            }
            case '0': {
                return 52;
            }
            case '1': {
                return 53;
            }
            case '2': {
                return 54;
            }
            case '3': {
                return 55;
            }
            case '4': {
                return 56;
            }
            case '5': {
                return 57;
            }
            case '6': {
                return 58;
            }
            case '7': {
                return 59;
            }
            case '8': {
                return 60;
            }
            case '9': {
                return 61;
            }
            case '+': {
                return 62;
            }
            case '/': {
                return 63;
            }
        }
        throw new UnsupportedOperationException("\u975e\u6807\u51c6base64\u5b57\u7b26:" + c);
    }
}

