/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.smc.compiler;

import com.jfirer.baseutil.smc.compiler.MemoryClassLoader;
import com.jfirer.baseutil.smc.compiler.MemoryJavaFileManager;
import com.jfirer.baseutil.smc.model.ClassModel;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileHelper {
    private static final Logger logger = LoggerFactory.getLogger(CompileHelper.class);
    private final MemoryClassLoader memoryClassLoader;
    private final JavaCompiler compiler;
    private final MemoryJavaFileManager manager;

    public CompileHelper() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public CompileHelper(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public CompileHelper(ClassLoader classLoader, JavaCompiler compiler) {
        if (compiler == null && (compiler = ToolProvider.getSystemJavaCompiler()) == null) {
            ServiceLoader<JavaCompiler> load = ServiceLoader.load(JavaCompiler.class, classLoader);
            Iterator<JavaCompiler> iterator = load.iterator();
            if (iterator.hasNext()) {
                compiler = iterator.next();
            } else {
                throw new NullPointerException("\u5f53\u524d\u5904\u4e8eJRE\u73af\u5883\u5e76\u4e14\u65e0\u6cd5\u4ee5SPI\u7684\u5f62\u5f0f\u83b7\u5f97JavaCompiler\u5b9e\u4f8b");
            }
        }
        this.compiler = compiler;
        this.memoryClassLoader = new MemoryClassLoader(classLoader);
        this.manager = new MemoryJavaFileManager(compiler.getStandardFileManager(null, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> compile(ClassModel classModel) throws IOException, ClassNotFoundException {
        try {
            String source = classModel.toStringWithLineNo();
            JavaFileObject javaFileObject = this.manager.makeStringSource(classModel.fileName(), source);
            StringWriter writer = new StringWriter();
            JavaCompiler.CompilationTask task = this.compiler.getTask(writer, this.manager, null, null, null, Arrays.asList(javaFileObject));
            Boolean result = task.call();
            if (result == null || !result.booleanValue()) {
                throw new RuntimeException("Compilation failed.The error is \r\n" + writer.toString() + "\r\nThe source is \r\n" + source);
            }
            logger.debug("\u7f16\u8bd1\u7684\u6e90\u4ee3\u7801\u662f:\r\n{}\r\n", (Object)source);
            this.memoryClassLoader.addClassBytes(this.manager.getClassBytes());
            Class<?> clazz = this.memoryClassLoader.loadClass("com.jfireframe.smc.output." + classModel.className());
            return clazz;
        }
        finally {
            this.manager.clear();
        }
    }
}

