/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.smc.compiler;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class MemoryClassLoader
extends URLClassLoader {
    Map<String, byte[]> classBytes = new HashMap<String, byte[]>();

    public MemoryClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public void addClassBytes(Map<String, byte[]> classBytes) {
        this.classBytes.putAll(classBytes);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] buf = this.classBytes.get(name);
        if (buf == null) {
            return super.findClass(name);
        }
        this.classBytes.remove(name);
        return this.defineClass(name, buf, 0, buf.length);
    }

    public Class<?> defineClass(String name, byte[] classBytes) {
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }
}

